<?php

/**
 * Class HostsUsingSameIdentitySqlBuilder
 */
class HostsUsingSameIdentitySqlBuilder extends BaseHealthDiagnosticSqlBuilder
{
    /**
     * @var string
     */
    protected $sql = 'SELECT HostKey
                      FROM hosts
                      WHERE HostKeyCollisions > %d
                      AND hostkey NOT IN
                      (
                          SELECT hostkey
                          FROM health_diagnostics_dismissed
                          WHERE username = \'%s\'
                            AND report_type = \'%s\'
                      )' ;

    /**
     * @var string
     */
    protected $nonOverlappedSql;

    /**
     * @var string
     */
    protected $reportSql = 'SELECT hosts.Hostkey AS key,
                                hosts.hostname AS "Host name",
                                hosts.Hostkey AS "Hostkey",
                                hosts.HostKeyCollisions AS "Host key collisions"
                            FROM hosts'; // WHERE is added in getReportSql()


    /**
     * @return string
     */
    public function getSql(): string
    {
        $sql = sprintf($this->sql, $this->data['hostsCollisionsThreshold'], $this->userName, BaseHealthDiagnostic::SAME_IDENTITY_TYPE);
        return $sql;
    }

    /**
     * Extend report sql by adding where in (report sql).
     * It needs to include in report only needed hosts.
     *
     * @return string
     */
    public function getReportSql(): string
    {
        // Check that hostkey is in the base (count) query (this->sql):
        $this->reportSql = sprintf($this->reportSql . ' WHERE HostKey IN (%s)', $this->getNonOverlappedSql());
        return $this->reportSql;
    }

}
