<?php

/**
 * Class InternalTasks
 */
class InternalTasks extends CfProtectedResource
{
    /**
     * Cfe_robot user name
     */
    public const CFE_ROBOT_USER = 'CFE_ROBOT';
    /**
     * @var CfTasks
     */
    protected $cfTasksLib;

    /**
     * InternalTasks constructor.
     *
     * @param $parameters
     *
     * @throws Exception
     */
    public function __construct($parameters)
    {
        parent::__construct($parameters);

        $user = $this->username;
        if ($user != self::CFE_ROBOT_USER) {
            throw new Exception('You are not permitted to access this resource.');
        }

        $this->cfTasksLib = new CfTasks();
    }
}

/**
 * @uri /internal-tasks/health-diagnostics-failures
 */
class UpdateHealthDiagnosticsCache extends InternalTasks
{
    public function post($request)
    {
        $response = new Response($request);

        try {
            $this->cfTasksLib->refreshHealthDiagnosticsFailures($this->username);
            $response->code = Response::ACCEPTED;
        } catch (PDOException $exception) {
            $response->code = Response::INTERNALSERVERERROR;
            $response->body = 'Data base error encountered while health diagnostics failures refreshing.';
            syslog(LOG_ERR, $exception->getTraceAsString());
        }

        return $response;
    }
}
