<?php

class cf_tcpdf extends TCPDF
{
    private $logoSVG = FCPATH . 'public/images/CFEngine_enterprise_logo.svg';
    private $logoWithoutAgent = FCPATH . 'public/images/CFEngine_logo_without.svg';
    private $currentY;
    private $pageWidthPx = 756;
    private $imgHeight = 34;

    public function printHeader($reportTitle, $description)
    {
        if ($customLogo = trim(getCustomLogoFile('logo_on_pdf'), '/')) {
            [$width, $height] = getimagesize($customLogo);
            // convert pixels to mm, multiplying by 0.264
            //  x = page width (756) - image width * (ratio) and convert to mm
            $this->Image(
                $customLogo,
                $x = $this->pixelsToMM($this->pageWidthPx - ($width * 40 / $height)),
                $y = $this->pixelsToMM(39),
                $w = '',
                $h = $this->pixelsToMM($this->imgHeight)
            );
        } else {
            $this->ImageSVG(
                $this->logoSVG,
                $x = $this->pixelsToMM(($this->pageWidthPx - 124)),
                $y = $this->pixelsToMM(39),
                $w = '',
                $h = $this->pixelsToMM($this->imgHeight)
            );
        }

        $this->currentY = $this->pixelsToMM(25);
        date_default_timezone_set('UTC');

        $this->SetFont($family = 'redhattextb', $style = '', $size = 21);
        $this->SetY($this->currentY);
        $this->SetRightMargin($this->pixelsToMM(170)); // set right margin to avoid description overlapping with logo and time
        $title = "<span style=\"font-weight: 700; font-size: 21px; line-height: 28px; color: #052569;\">{$reportTitle}</span>";
        $this->writeHTML($title);

        $titleLines = ceil(strlen($reportTitle) / 35);
        if ($titleLines > 1) {
            $titleHeight = $titleLines * $this->pixelsToMM(35) +  $this->pixelsToMM(30);
            $this->currentY += $titleHeight;
            $this->SetY($this->currentY);
        }

        $this->SetFont($family = 'redhattext', $style = '', $size = 11);
        $time = '<span style="color: #646566;  font-weight: 500;">' . date('Y-m-d H:i:s T', time()) . '</span>';
        $this->writeHTML($time);
        $this->writeHTML("<div style=\"font-weight: 500; line-height: 15px;  color: #0B132A;\">$description</div>");

        $this->SetY($this->currentY);
        // every line has 50 characters
        $descLines = ceil(strlen($description) / 50);

        // calculate description height
        $descHeight = $descLines * 6 + 20;
        // add title size to Y
        $this->currentY += max($descHeight, 30);

        $this->SetY($this->currentY);
        $this->SetRightMargin(10);
        $this->currentY += 10;
    }

    public function AddPage($orientation = '', $format = '', $keepmargins = false, $tocpage = false)
    {
        parent::AddPage($orientation, $format, $keepmargins, $tocpage);

        // add blue line to every page
        $this->Line($x1 = 0, $y1 = 0, $x2 = 756, $y2 = 0, $style = ['width' => 6, 'color' => [5, 37, 105]]);
    }

    // Page footer
    public function Footer()
    {
        $this->SetY(-10);
        $this->ImageSVG(
            $this->logoWithoutAgent,
            $x = $this->x,
            $y = $this->y + 2
        );
        $this->SetFont('helvetica', $style = '', $size = 9);
        $this->Line($x1 = $this->x, $y1 = $this->y, $x2 = 200, $y2 = $this->y, $style = ['width' => 0.1, 'color' => [152, 166, 206]]);
        // Page number
        $this->Cell($w = 0, $h = 10, $txt = $this->getAliasNumPage(), $border = 0, $ln = 0, $align ='R');
    }


    public function pixelsToMM($px)
    {
        return $px * 0.264;
    }

}
