<?php

class CF_Rule {
    var $id;
    var $username;
    var $name;
    var $description;
    var $type;
    var $category;
    var $conditionMustBeMet;
    var $severity;
    var $policyConditions;
    // inventory
    var $inventoryConditions;
    var $softwareUpdateConditions;
    var $customConditions;
    var $fileChangedConditions;
    var $hostcontexts;
    var $export_id;


    function __construct($params=array()) {
// common properties
        $this->id               = isset($params['id'])            ? intval($params['id'])   : null;
        $this->username         = isset($params['username'])      ? $params['username']     : null;
        $this->name             = isset($params['name'])          ? $params['name']         : null;
        $this->description      = isset($params['description'])   ? $params['description']  : null;
        $this->type             = isset($params['type'])          ? $params['type']         : null;
        $this->category         = isset($params['category'])      ? $params['category']     : 'uncategorized';
        $this->severity         = isset($params['severity'])      ? $params['severity']     : null;
        $this->conditionMustBeMet = isset($params['conditionmustbemet']) ? $params['conditionmustbemet'] : null;

//type-based properties

        $this->policyConditions         = isset($params['policyconditions'])         ? json_decode($params['policyconditions'],         true) : null;

        $this->inventoryConditions      = isset($params['inventoryconditions'])      ? json_decode($params['inventoryconditions'],      true) : null;

        $this->softwareUpdateConditions = isset($params['softwareupdateconditions']) ? json_decode($params['softwareupdateconditions'], true) : null;

        $this->customConditions = isset($params['customconditions']) ? json_decode($params['customconditions'], true) : null;

        $this->fileChangedConditions = isset($params['filechangedconditions']) ? json_decode($params['filechangedconditions'], true) : null;

        $this->hostcontexts = isset($params['hostcontexts']) ? json_decode($params['hostcontexts'], true) : null;

        $this->export_id = $params['export_id'] ?? null;
    }

    function getId()
    {
        return $this->id;
    }

    function getUsername()
    {
        return $this->username;
    }

    function getName()
    {
        return $this->label;
    }

    function getDescription()
    {
        return $this->description;
    }

    function getType()
    {
        return $this->type;
    }

    public function getConditionMustBeMet()
    {
        return $this->conditionMustBeMet;
    }

    function getPolicyConditions()
    {
        return $this->policyConditions;
    }

    function getInventoryCondition()
    {
        return $this->inventoryConditions;
    }

    function getSoftwareUpdateConditions()
    {
        return $this->softwareUpdateConditions;
    }

    function getCustomConditions()
    {
        return $this->customConditions;
    }

    public function getFileChangedConditions()
    {
        return $this->fileChangedConditions;
    }

    public function getExportId()
    {
        return $this->export_id;
    }
}
