<div class="settingsPage">

    <div class="left-column">
        <?php include('settingsSideBar.php'); ?>
    </div>

    <div class="right-column">

        <div class="pageTitle">
            <h1>
                <?php
                if ($form_data['scriptname']) { ?>
                   <span>Edit custom script</span>
                <?php }
                else { ?>
                   <span>Add a custom script</span>
                <?php } ?>
            </h1>
        </div>

        <div class="pullTop">

            <?php
            if (($this->session->flashdata('message')) || (!empty($message) && is_array($message)))
            {
                $flashMessage = $this->session->flashdata('message') ? $this->session->flashdata('message') : $message;
                $content = $flashMessage['content'];
                $content_class = $flashMessage['type'];
                ?>

                <div class="alert <?= htmlspecialchars($content_class) ?>
                     ">
                    <button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>
                    <?= nl2br(htmlspecialchars($content)); ?>
                </div>
            <?php } ?>
        </div>

        <?php
        $attributes = array('class' => 'form-horizontal confirm-before-leave', 'id' => 'notificationUpdate', 'autocomplete' => "off");
        echo form_open_multipart('', $attributes);

        ?>
        <div class="control-group required">
            <label class="control-label" for="script_file">File</label>

            <div class="controls level-text">
                <?php if (!empty($form_data['scriptfilename'])) {  ?>
                    <p><?= htmlspecialchars($form_data['scriptfilename']) ?></p>
                <?php } ?>

                <input type="file" name="userfile" id="userfile" size="20" title="Choose file"/>

                <span class="help-block">upload your custom script.</span>

            </div>
        </div>

        <div class="control-group required">
            <label class="control-label" for="host">Name</label>

            <div class="controls">
                <input id="scriptname" type="text" name="scriptname" class="input-xlarge" value="<?= htmlspecialchars($form_data['scriptname']) ?>"/>

                <p class="help-block">Name of the script</p>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label" for="host">Description</label>

            <div class="controls">
                <textarea id="scriptdescription" name="scriptdescription" class="input-xlarge"><?= htmlspecialchars($form_data['scriptdescription']) ?></textarea>

                <p class="help-block">Small description about the script</p>
            </div>
        </div>



        <input type="hidden" name="id" id="id" value="<?= htmlspecialchars($form_data['id']) ?>">
        <input type="hidden" name="update" id="update" value="1">

        <div class="buttons">
            <a class="btn btn-large" type="button" href="/settings/notification-scripts">Cancel</a>
            <div class="pull-right">
                <?php echo form_submit(array('name' => 'submit', 'class' => 'btn btn-primary btn-large', 'value' => 'Save')); ?>
            </div>
        </div>

        <?php echo form_close(); ?>

    </div>
</div>

<script type="text/javascript">
    $(document).ready(function(){
        $('input[type=file]').bootstrapFileInput();
        document.getElementById('userfile').addEventListener('change', (event)=>{
            const scriptInput = $('#scriptname');
            if (scriptInput.val() === ""){
                const selectedFile = event.target.files[0];
                scriptInput.val(selectedFile.name);
            }
        })
        $('.file-input-wrapper').addClass('btn-large');
    });
</script>
