<main id="ngApp">
    <div ng-controller="hostInfoController">
        <?php if ($showHeader) { ?>
            <div id="hostInfoWrap" class="margin-bottom contentWrapper">
                <h4 class="margin-top-small"><?= $isHub ? 'Hub' : 'Host' ?> information</h4>
                <div class="pageTitle">
                    <h1>
                        <?= isset($Hostnames['Fqhost']) ? $Hostnames['Fqhost'] : 'Undefined' ?>
                    </h1>
                </div>
            <?php } ?>
            <div class="relative">
                <div class="host-buttons">

                    <button
                        <?php if (isActionAllowed('host.delete')) { ?>
                        title="Remove host"
                        <?php } else { ?>
                        title="Your role does not have enough privileges to perform host deletion"
                        disabled="disabled"
                        <?php } ?>
                        id="assets-remove-host-button"
                        key="<?= htmlspecialchars($hostkey) ?>"
                        class="float-right btn btn-info">
                        <i class="bi bi-trash"></i>
                    </button>

                    <button title="Copy link"
                        class="float-right btn btn-info margin-right-xs"
                        id="copy-host-link">
                        <i class="bi bi-share"></i>
                    </button>

                    <button
                        <?php if (!$isSuperHub) { ?>
                        title="Request report collection"
                        <?php } else { ?>
                        title="Request report collection is not allowed on the Superhub"
                        disabled="disabled"
                        <?php } ?>
                        class="float-right btn btn-primary request-report-collection margin-right-xs"
                        disabled="disabled"
                        data-hostkey="<?= htmlspecialchars($hostkey) ?>"
                        data-last-report="<?= htmlspecialchars($last) ?>">
                        <i class="bi bi-arrow-repeat"></i>
                    </button>
                    <button
                        <?php if (!$isSuperHub) { ?>
                        title="Trigger agent run"
                        <?php } else { ?>
                        title="Agent run triggering is not allowed on the Superhub"
                        disabled="disabled"
                        <?php } ?>
                        class="float-right btn btn-primary trigger-agent-run margin-right-xs"
                        disabled="disabled"
                        data-hostkey="<?= htmlspecialchars($hostkey) ?>"
                        data-last-report="<?= htmlspecialchars($last) ?>">
                        <i class="bi bi-caret-right-fill"></i>
                    </button>

                </div>
            </div>
            <div class="row-fluid host-details">
                <div class="span6">
                    <div>
                        <h4>
                            CFEngine
                        </h4>
                        <div class="row-fluid"><span class="span5">ID:</span>
                            <span class="span6 host_id_SE" style="word-wrap:break-word">
                                <?= htmlspecialchars($hostkey) ?>
                                <?php $this->load->view('common/copy-to-clipboard.php'); ?>
                            </span>
                        </div>
                        <div class="row-fluid"><span class="span5">Version:</span>
                            <span class="span6">
                                <?= htmlspecialchars($CFEngine['Version']) ?>
                                <?php $this->load->view('common/copy-to-clipboard.php'); ?>
                            </span>
                        </div>
                        <div class="row-fluid"><span class="span5">Role:</span>
                            <span class="span6">
                                <?= $isHub ? 'Hub' : 'Client' ?>
                                <?php $this->load->view('common/copy-to-clipboard.php'); ?>
                            </span>
                        </div>
                        <div class="row-fluid"><span class="span5">IP Reported from:</span>
                            <span class="span6">
                                <?= ($ipaddr == "") ? $this->lang->line('host_not_discovered') : htmlspecialchars($ipaddr) ?>
                                <?php $this->load->view('common/copy-to-clipboard.php'); ?>
                            </span>
                        </div>
                        <div class="row-fluid"><span class="span5">Initiated by:</span>
                            <span class="span6">
                                <?= htmlspecialchars($collectionInitiatedBy) ?>
                                <?php $this->load->view('common/copy-to-clipboard.php'); ?>
                            </span>
                        </div>
                        <div class="row-fluid"><span class="span5">Average agent execution interval:</span>
                            <span class="span6">
                                <?= htmlspecialchars($agentExecutionInterval) ?> seconds
                                <?php $this->load->view('common/copy-to-clipboard.php'); ?>
                            </span>
                        </div>
                        <div class="row-fluid"><span class="span5">Last report:</span>
                            <span class="span6">
                                <?php echo getDateStatus($last); ?>
                                <?php $this->load->view('common/copy-to-clipboard.php'); ?>
                            </span>
                        </div>
                        <div class="row-fluid"><span class="span5">Last agent run:</span>
                            <span class="span6">
                                <?= getDateStatus($lastAgentExecutionTime) ?>
                                <?php $this->load->view('common/copy-to-clipboard.php'); ?>
                            </span>
                        </div>
                        <div class="row-fluid"><span class="span5">First report:</span>
                            <span class="span6">
                                <?= getDateStatus($firstReport, true) ?>
                                <?php $this->load->view('common/copy-to-clipboard.php'); ?>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="span6">
                    <div>
                        <h4>System</h4>
                        <div class="row-fluid"><span class="span5">OS:</span>
                            <span class="span6">
                                <?= (isset($System['OS']) && !empty($System['OS'])) ? htmlspecialchars($System['OS']) : $this->lang->line('host_not_discovered') ?>
                                <?php $this->load->view('common/copy-to-clipboard.php'); ?>
                            </span>
                        </div>
                        <div class="row-fluid"><span class="span5">Hostname:</span>
                            <span class="span6 host_alias">
                                <?= ($hostname == "") ? $this->lang->line('host_not_discovered') : htmlspecialchars($hostname) ?>
                                <?php $this->load->view('common/copy-to-clipboard.php'); ?>
                            </span>
                        </div>
                        <div class="row-fluid"><span class="span5">IPv4 addresses:</span>
                            <span class="span6">
                                <?= !empty($Network['address']) ? PgsqlArrayToCommaSeparatedList($Network['address']) : 'n/a' ?>
                                <?php $this->load->view('common/copy-to-clipboard.php'); ?>
                            </span>
                        </div>
                        <div class="row-fluid"><span class="span5">Installed packages:</span>
                            <span class="span6">
                                <?php echo anchor('/reports/report/run?state=' . rawurlencode($software_installed_state) . '&title=Software installed on ' . $hostname, $software_installed, array('class' => 'total_software_installed_SE')); ?>
                            </span>
                        </div>
                        <div class="row-fluid"><span class="span5">Updates available:</span>
                            <span class="span6">
                                <?php echo anchor('/reports/report/run?state=' . rawurlencode($patches_available_state) . '&title=Updates available on ' . $hostname, $patches_available,  array('class' => 'total_patches_available_SE')); ?>
                            </span>
                        </div>
                    </div>
                    <h4>Status</h4>
                    <div id="statusmeasured" style="margin:22px 0px;">
                        <div class="row-fluid"><span class="span5"><?php echo $this->lang->line('host_average_load') ?>:</span><span class="span7"><?php echo $load ?>%</span></div>
                        <div class="row-fluid"><span class="span5"><?php echo $this->lang->line('host_free_disk') ?>:</span> <span class="span7"><?php echo $free ?>%</span></div>
                    </div>
                </div>
            </div>


            <hr class="horizontalLine1px" />
            <div class="relative" style="min-height: 80px">
                <div class="margin-top">
                    <h4 title="Ordered by priority, data from the more specific groups at the end of the list is preferred when merging.">Groups</h4>
                    <?php
                    if (isset($groups) && !empty($groups)) {
                    ?>
                        <div class="row-fluid">
                            <span class="span2">Shared groups:</span>
                            <span class="span10">
                                <?php
                                for ($i = 0; $i < sizeof($groups); $i++) {
                                    if ($i == 20 && sizeof($groups) > 20) {
                                        echo '<button class="btn btn-link btn-moreless" id="moreLink">Show more...</button><span id="more" style="display:none">';
                                    }
                                    $group = $groups[$i];
                                    echo '<a class="btn-blue-link" style="vertical-align:baseline" href="' . site_url() . 'groups/shared/' . $group->id . '">' . $group->name . '</a>';
                                    if ($i < sizeof($groups) - 1) {
                                        echo ", ";
                                    }
                                }
                                if (sizeof($groups) > 20) {
                                    echo '</span>. <button class="btn btn-link btn-moreless" id="lessLink" style="display:none">Show less</button>';
                                }
                                ?>
                            </span>
                        </div>
                    <?php
                    } elseif (isset($groups_access_denied)) {
                        echo "You don't have access to 'Get shared host groups'. Contact your administrator to gain access.";
                    } else {
                        echo "No groups found.";
                    }
                    ?>
                </div>
            </div>

            <hr class="horizontalLine1px" />
            <div class="row-fluid host-details">
                <div class="span12">
                    <?php if (!$isSuperHub) { ?>
                        <div>
                            <div
                                id="cmdb-root"
                                style="min-height: 300px"
                                data-props='{"displayShowJson": true,"identifier":"<?= $hostkey ?>", "ishub" : <?= $isHub ? 'true' : 'false' ?>, "cmdbServiceUrl": "/cmdb"}'>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <hr class="horizontalLine1px margin-top-large" />
            <div class="relative" style="min-height: 100px">
                <div id="pinned_items_wrapper"></div>
                <button class="btn btn-dark-blue inventory-report-btn"
                    data-url="<?= site_url('reports/inventory?host_name=' . urlencode($Hostnames['Fqhost']) . '&columns=Host name,OS,Kernel Release,Memory size (MB)') ?>"> Open inventory report</button>
            </div>
            <hr class="horizontalLine1px margin-top-large" />
            <div>
                <div>
                    <h4>Measurements</h4>
                    <div id="host-vital"></div>
                </div>
            </div>
            <?php if (isset($policiesExecutionInfo['rows']) && !empty($policiesExecutionInfo['rows'])) { ?>
                <hr class="horizontalLine1px" />
                <div>
                    <h4>Agent execution time </h4>
                    <?= createTableFromApiResponse($policiesExecutionInfo) ?>
                </div>
                <hr class="horizontalLine1px" />
            <?php } ?>

            </div>
    </div>
</main>

<div class="modal  hide" id="vital-detail-modal-hostpage" tabindex="-1">

    <div class="modal-body vitalsModal">
        Loading..
    </div>
</div>

<!-- Modal host delete conformation -->

<div id="hostdelconfirmation" title="Proceed Host Deletion" style="display:none">
    <span>
        <?php
        echo $this->lang->line('host_delete_confirm');
        ?>
    </span>
</div>

<div class="modal fade hide" id="hostDeleteSuccess" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-body">
        <p class="alert alert-success">Host(s) deleted successfully</p>
    </div>
    <div class="modal-footer">
        <button class="btn" data-dismiss="modal" id="host-deleted-sucessfull-btn">Close</button>
    </div>
</div>

<div class="modal fade hide" id="hostDeleteUnSuccessful" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-body">
        <p class="alert alert-error">There was some error encountered while deleting the host(s).</p>
    </div>
    <div class="modal-footer">
        <button class="btn" data-dismiss="modal" id="host-deleted-sucessfull-btn">Close</button>
    </div>
</div>


<script type="text/javascript">
    var moreLinkEl = document.getElementById('moreLink');
    var moreEl = document.getElementById('more');
    var lessLinkEl = document.getElementById('lessLink');

    if (moreLinkEl && lessLinkEl) {
        moreLinkEl.addEventListener('click', more, false);
        lessLinkEl.addEventListener('click', less, false);
    }

    function more() {
        moreLink.style.display = 'none';
        moreEl.style.display = 'inline';
        lessLinkEl.style.display = 'inline';
    }

    function less() {
        moreLink.style.display = 'inline';
        moreEl.style.display = 'none';
        lessLinkEl.style.display = 'none';
    }

    var hostNameEl = document.querySelector('h1 > span > span:last-child');
    if (hostNameEl) {
        hostNameEl.innerHTML = '<?= isset($Hostnames['Fqhost']) ? addslashes($Hostnames['Fqhost']) : 'Undefined' ?>';
    }
    var helpEl = document.querySelector('.help');
    if (helpEl) {
        helpEl.style.display = 'contents';
    }

    if (typeof loadPageTimeOut === 'undefined') {
        var loadPageTimeOut = null;
    }

    var AssetsPlugins = {};
    // module to delete host used in this page and compliance table grid
    AssetsPlugins.deleteHost = function() {

        var pub = {}; // public methods and vars

        var deleteHostMessage = '<?php echo $this->lang->line('host_delete_confirm'); ?>';
        var deleteHostFailedMessage = 'There was some error encountered while deleting the host(s).';
        var deleteHostSuccessMessage = 'Host deleted sucessfully!'

        pub.deleteHosts = function(arrayKeys) {
            $("<div></div>")
                .dialog_modal({
                    passedArgs: [deleteHostMessage, [{

                        "label": "Cancel",
                        "class": "btn btn-large",
                        "callback": function() {}
                    }, {
                        "label": "Remove",
                        "class": "btn btn-large btn-primary btn-danger",
                        "callback": function() {
                            var parameters = {
                                'delhosts[]': arrayKeys
                            };
                            processRequest(parameters).then(showHostDeleteSuccess).fail(showHostDeleteFailure);
                        }
                    }], {
                        header: "<h2>Remove host?</h2>",
                        'onEscape': function() {}
                    }]
                })
        };

        var showHostDeleteSuccess = function() {
            common.globalSpinner.hide();
            var errorMessage = $('<p></p>')
                .append(deleteHostSuccessMessage)
                .addClass('alert alert-success');

            bootbox.alert(errorMessage, function() {
                window.location.href = "<?php site_url(); ?>";
            });

        };

        var showHostDeleteFailure = function(jqXHR, textStatus, errorThrown) {
            common.globalSpinner.hide();
            var errorMessage = $('<p></p>')
                .append(deleteHostFailedMessage)
                .append('<br/>')
                .append(jqXHR.responseText)
                .addClass('alert alert-error');

            bootbox.alert(errorMessage);
        };

        var processRequest = function(parameters) {
            common.globalSpinner.show();
            return $.ajax({
                type: "POST",
                url: "<?php echo site_url(); ?>/host/delhosts",
                data: parameters,
                async: true
            });
        };

        return pub;
    }();

    $(document).ready(function() {

        $("#assets-remove-host-button").on("click", function(e) {
            e.preventDefault();
            var target = $(this);
            var key = target.attr('key');
            var arrayKeys = [];
            arrayKeys.push(key);
            AssetsPlugins.deleteHost.deleteHosts(arrayKeys);
        });



        var genericOption = {
            baseUrl: '<?php echo site_url() ?>',
            showVitalSelectionForHost: true,
            disableExtraButtons: true,
            disableScrollOnTop: true,
            graphclicked: function(e, data) {
                var options = {
                    'remote': genericOption.baseUrl + '/vitals/vital_detail_view/' + data.hostkey + '/' + data.obs
                };
                var dialogBody = {
                    'header': "",
                    'body_url': options.remote,
                    'onEscape': function() {}
                };
                $("<div></div>")
                    .dialog_modal({
                        passedArgs: ['', [], dialogBody],
                        css: {
                            'width': function() {
                                return ($(document).width() * .8) + 'px';
                            },

                            'margin-left': function() {
                                return -($(this).width() / 2);
                            }
                        },
                        addBodyClass: 'vitalsModal'
                    })
                $(document).off('focusin.modal');
                return;

            }
        };

        if (loadPageTimeOut !== null) {
            clearTimeout(loadPageTimeOut);
        }
        // avoid host page loaded event triggering twice within 1 second
        loadPageTimeOut = setTimeout(() => {
            $('#host-vital').vitalSigns(genericOption);
            $('#host-vital').vitalSigns('setHostObservables', 'loadavg');
            $('#host-vital').vitalSigns('setHostContext', '<?= htmlspecialchars($hostkey) ?>', true);
            $('html').trigger('host-page-loaded');
        }, 1000);

    });
</script>