#!/usr/bin/env bash
# designed for ubuntu 22
set -ex
export DEBIAN_FRONTEND=noninteractive
sudo apt -y install software-properties-common
sudo add-apt-repository ppa:ondrej/php -y
sudo apt-get update
# curl dep for cf-remote, not required but avoids an error
sudo apt-get install -y \
  acl \
  curl \
  default-jre \
  php8.2-cli \
  php8.2-curl \
  php8.2-gd \
  php8.2-ldap \
  php8.2-mbstring \
  php8.2-mysql \
  php8.2-pgsql \
  php8.2-xdebug \
  php8.2-xml \
  php8.2-zip \
  sudo \
  systemd \
  wget \
  xvfb

# firefox dependencies
sudo apt-get install -y \
  bzip2 \
  libgtk-3-0

if [ ! -f /usr/local/bin/composer ]; then
  wget https://getcomposer.org/installer
  sudo php installer --install-dir=/usr/local/bin --filename=composer
  rm installer
fi

cat <<EOF | sudo tee /etc/systemd/system/xvfb.service
[Unit]
Description=X Virtual Frame Buffer Service

[Service]
Environment="DISPLAY=:1"
ExecStart=/usr/bin/Xvfb :1 -screen 0 1920x1080x16
StandardOutput=append:/var/log/xvfb.log
StandardError=append:/var/log/xvfb.log

[Install]
WantedBy=multi-user.target
EOF

pushd /opt
wget -q -O - "https://download.mozilla.org/?product=firefox-latest&os=linux64&lang=en-US" | sudo tar -xvj
sudo ln -s $PWD/firefox/firefox /usr/bin/firefox
ls -l $(which firefox)
firefox --version

wget -q -O - "https://github.com/mozilla/geckodriver/releases/download/v0.35.0/geckodriver-v0.35.0-linux64.tar.gz" | sudo tar -xvz
sudo ln -sf $PWD/geckodriver /usr/bin/geckodriver
