'use strict';
/*
 * Service to work with http
 *
 **/
var healthDiagnosticsServiceClass = Class.extend({
    dismissHosts: function(listOfKeys, type)
    {
        var keys = listOfKeys || [];
        var data = $.param({hosts :keys, type: type});
        if (keys.length)
        {
            return this.$http({
                method: 'POST',
                url: MP_SITE_URL + '/advancedreports/HealthDiagnostic/dismiss',
                headers : {
                    'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
                },
                data: data,
                cache: false
            });
        }
        return false;
    },

    removeFromDismissed: function(listOfKeys, type)
    {
        var keys = listOfKeys || [];
        var data = $.param({hosts :keys, type: type});
        if (keys.length)
        {
            return this.$http({
                method: 'DELETE',
                url: MP_SITE_URL + '/advancedreports/HealthDiagnostic/dismiss/' + type + '/' + listOfKeys.join('|'),
                headers : {
                    'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
                },
                data: data,
                cache: false
            });
        }
        return false;
    },


    getDismissedHosts: function (type) {
        return this.$http({
            method: 'GET',
            url: MP_SITE_URL + '/advancedreports/HealthDiagnostic/dismiss/' + type + '?offset=0&limit=-1' ,
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            cache: false
        });

    },

    deletePermanently: function (hostkey) {
        return this.$http({
            method: 'DELETE',
            url: MP_SITE_URL + '/host/delete_host_permanently/' + hostkey ,
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            cache: false
        });
    },   
    
    restoreDeletedHost: function (hostkey) {
        return this.$http({
            method: 'POST',
            url: MP_SITE_URL + '/host/restore_deleted_host/' + hostkey ,
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            cache: false
        });
    },
});



(function() {
    var healthDiagnosticsServiceProvider = Class.extend({
        instance: new healthDiagnosticsServiceClass(),
        $get: ['$http', function($http) {
            this.instance.$http = $http;
            return this.instance;
        }]
    });

    angular.module('healthDiagnosticsServiceModule', [])
        .provider('healthDiagnosticsService', healthDiagnosticsServiceProvider);

}());