angular.
        module('changesDirectives', []).
        directive('changesfilter', ['$q', function($q) {
        return {
            restrict: 'C',
            link: function($scope, $elm, $attrs) {
                new changesFilterDirectiveCtrl($scope, $elm, $attrs, $q);
            },
            scope: {
                ui : '=',              // UI object
                filters: '='
            },
            templateUrl: MP_SITE_URL + '/directives/partials/directive_changesfilter.php'
        };
    }]).filter('setDefaultConditionOption', function() {
    /**
     * Sets default condition option for filter
     *
     * @param {string} input - original value from model
     * @param {string} defaultVal - default value
     * @returns {string}
     */
    return function(input, defaultVal) {
        if (input)
            return input;
        else
        return defaultVal;
    };
    }).filter('getLabelByValue', function() {
    return function(input, condition) {
        // return a filter condition from an array given a filter value
        var result = [];
        angular.forEach(input, function(val, key) {
            if (val.value === condition) {
                result.push(val);
                return;
            }
        });
        if (angular.equals([], result)) {
            result.push(input[0]);
        }
        return result;
    };
});