/*
  Predefined SQL and conditions
 */

var defaultSQL = {};
    defaultSQL.SELECT = 'SELECT ';

   // defaultSQL.SELECT_INVENTORY_RULE = 'SELECT DISTINCT Hosts.HostKey ';

    defaultSQL.FROM   = 'FROM Hosts INNER JOIN INVENTORY ON INVENTORY.HostKey = Hosts.HostKey';
    defaultSQL.WHERE  = 'WHERE';
    defaultSQL.HAVING = 'HAVING';
    defaultSQL.GROUP  = 'GROUP BY Hosts.hostkey ';
    // don't forget to add ) at the end
    defaultSQL.SOFTWARE_WHERE  = ' Hosts.hostkey NOT IN ( SELECT DISTINCT hostkey FROM software WHERE ';

  // 'cf_clearslist' - custom PostgreSQL function
  var SLIST_DEFAULT_CONVERT_FUNCTION = 'cf_clearslist';

  var  NUMERIC_CONDITION = [
        {"value": "=",         "label": "="    },
        {"value": "!=",        "label": "!="   },
        {"value": ">",         "label": ">"    },
        {"value": "<",         "label": "<"    },
        {"value": "is_reported", "label": "is reported"},
        {"value": "is_not_reported", "label": "is not reported"},

  ];


 //http://www.postgresql.org/docs/9.3/static/functions-matching.html
  var STRING_CONDITION =  [
        {"value": "matches", "label": "matches", "tooltip": "Variable is reported and matches string (% for wildcard)"},
        {"value": "not_match", "label": "doesn't match", "tooltip": "Variable is reported and doesn't match string (% for wildcard)"},
        {"value": "=", "label": "is", "tooltip": "Variable is reported and is the given string" },
        {"value": "!=", "label": "is not", "tooltip": "Variable is reported and is not the given string" },
        {"value": "regex_matches", "label": "regex matches", "tooltip": "Variable is reported and matches the regular expression (POSIX regex)"},
        {"value": "regex_not_match", "label": "regex doesn't match", "tooltip": "Variable is reported and doesn't match the regular expression (POSIX regex)"},
        {"value": "is_reported", "label": "is reported", "tooltip": "Variable is reported"},
        {"value": "is_not_reported", "label": "is not reported", "tooltip": "Variable is not reported"}
    ];


  var LIST_CONDITION = [
      {"value": "contains", "label": "contains", "tooltip": "List variable is reported and at least one item of the list contains the given string (% for wildcard)"},
      {"value": "not_contain", "label": "doesn't contain", "tooltip": "List variable is reported and no items of the list contains the given string (% for wildcard)"},
      {"value": "matches", "label": "matches", "tooltip": "List variable is reported and at least one item of the list match the given string"},
      {"value": "not_match", "label": "doesn't match", "tooltip": "List variable is reported and no items of the list match the given string"},
      {"value": "is_reported", "label": "is reported", "tooltip": "Variable is reported"},
      {"value": "is_not_reported", "label": "is not reported", "tooltip": "Variable is not reported"}

  ];

  var CONTEXT_CONDITION = [
        {"value": "matches",     "label": "matches"        },
        {"value": "not_match", "label": "doesn't match"  },
        {"value": "=",         "label": "is"             },
        {"value": "!=",        "label": "is not"         },
        {"value": "is_reported", "label": "is reported"},
        {"value": "is_not_reported", "label": "is not reported"},
  ];


  var DATE_CONDITION = [
        {"value": "<",         "label": "before"},
        {"value": ">",         "label": "after" },
        {"value": "is_reported", "label": "is reported"},
        {"value": "is_not_reported", "label": "is not reported"},
  ];


  var FIELD_TYPES  = [
        {"value": "string",    "label": "string" },
        {"value": "int",       "label": "integer"},
        {"value": "real",      "label": "real"   },
        {"value": "slist",     "label": "list"   },
        {"value": "context",   "label": "context"}
   ];


window.defaultSQL = defaultSQL;
window.SLIST_DEFAULT_CONVERT_FUNCTION = SLIST_DEFAULT_CONVERT_FUNCTION;
window.NUMERIC_CONDITION = NUMERIC_CONDITION;
window.STRING_CONDITION = STRING_CONDITION;
window.LIST_CONDITION = LIST_CONDITION;
window.CONTEXT_CONDITION = CONTEXT_CONDITION;
window.DATE_CONDITION = DATE_CONDITION;
window.FIELD_TYPES = FIELD_TYPES;
