/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*global BaseController, angular, DCA*/

'use strict';

var eventsController = BaseController.extend({
    /**
     * Initialize  Controller
     * @param $scope, current controller scope
     */
    init: function($scope, $location, $timeout, eventsLogService) {
        var self = this;
        this._super($scope);

        this.$location = $location;
        this.$timeout = $timeout;

        self._eventsLogService = eventsLogService;

        self.$scope.DCA = DCA;
        self.$scope.Math = Math;

        self.$scope.eventsLog = {};

        self.$scope.todayDate = new Date();
        self.$scope.minDate = self._returnDate(29);
        self.$scope.weekDate = self._returnDate(6);
        self.$scope.yesterDate = self._returnDate(1);

        let queryParams = $location.search();

        self.$scope.myDateRange = {
            startDate: queryParams.from != undefined ? queryParams.from : self.$scope.weekDate,
            endDate: queryParams.to != undefined ? queryParams.to : self.$scope.todayDate,
            maxDate: self.$scope.todayDate
        };


        self.$scope.type =  {
            availableOptions: [
                 {id: 'all', name: 'Select type'}
            ],
            selectedOption: queryParams.type != undefined ? {id: queryParams.type} : {id: 'all', name: 'Select type'}
        };
        self.setEventTypes();

        self.$scope.currentPage = 1;
        self.$scope.pageSize = 10;
        self.$scope.totalItems = 4;
        self.$scope.maxSize = 5;
        self.$scope.numPages = 1;
        var offset = (self.$scope.currentPage -1) * self.$scope.pageSize;
        self.$scope.filter = {
            'limit':self.$scope.pageSize,
            'offset': offset,
            'dateFilter' : {
                'dtFrm': self._setTimeStamps(self.$scope.myDateRange.startDate),
                'dtTo': self._setTimeStamps(self.$scope.myDateRange.endDate)
            }
        };

        self.$scope.dateOpts = {
            ranges: {
                'Today': [self.$scope.todayDate,self.$scope.todayDate],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()]
            },
            applyClass: 'btn-primary',
            separator: ' to ',
            buttonClasses: ['pull-right', 'btn']
        };

        self.$scope.$watchCollection('type.selectedOption', function () {
            self.$scope.filter.type = self.$scope.type.selectedOption.id;
            self._refreshEvents();
        })

        //Watch for date changes & communicate with directive to show on screen
        self.$scope.$watch('myDateRange', function(oldDate, newDate) {
            if (!self.$scope.initializing) {
                // convert dates to timestamps
                self.$scope.filter.dateFilter = {
                    dtFrm: self._setTimeStamps(self.$scope.myDateRange.startDate),
                    dtTo: self._setTimeStamps(self.$scope.myDateRange.endDate)
                };
                self.$scope.search();
            }
            if (oldDate !== newDate) {
                self.$scope.$broadcast('changeTmpEvent', self.$scope.myDateRange);
            }
        }, true);

    },

    defineListeners: function() {
        var self = this;

        self.$scope.$watch('currentPage', function(newPage) {
           self.$scope.$broadcast("pageChangeEvent", newPage);
        });

        self.$scope.$on("pageChangeEvent",function(event,newPage) {

            self.$scope.filter.limit = self.$scope.pageSize;
            self.$scope.filter.offset = (newPage -1) * self.$scope.pageSize;
            self._refreshEvents();
        });

        this._super();

    },

    defineScope: function() {
        this.$scope.instance = "eventsController";

        this.$scope.setPageSize = this.setPageSize.bind(this);
        this.$scope.search = this.search.bind(this);
        this.$scope.delaySearch = this.delaySearch.bind(this);

    },

    search: function() {
        var self = this;
        self.$scope.filter.eventFilter = self.$scope.searchEvents;
        this._refreshEvents();
    },

    delaySearch: function(search) {
        var self = this;

        if (self.$scope.filterTextTimeout) self.$timeout.cancel(self.$scope.filterTextTimeout);

        self.$scope.filterTextTimeout = self.$timeout(function() {
           self.$scope.search();
        }, 250); // delay 250 ms
    },

    _refreshEvents: function() {
        var self = this;
        self._eventsLogService.geteventslog(self.$scope.filter).then(function(result) {
            self.$scope.eventsLog = result.data.data;
            self.$scope.totalItems = result.data.totalCount;
            self.$scope.numPages = Math.ceil(result.data.totalCount / self.$scope.pageSize);
        }, function(error) {
            // TODO:
            // Error notification
        });
    },

    setEventTypes: function() {
        var self = this;
        self._eventsLogService.getEventTypes().then(function(result) {

            result.data.forEach(function(item) {
                self.$scope.type.availableOptions.push({id: item.type , name:  item.type.charAt(0).toUpperCase() +  item.type.slice(1) + ' events'})
            });

        }, function(error) {
            // TODO:
            // Error notification
        });
    },

    setPageSize: function(size) {
        var self = this;
        self.$scope.pageSize = size;
        self.$scope.$broadcast("pageChangeEvent", 1);
    },

    _returnDate: function(days) {
        var self = this;
        return new Date(new Date().setDate(self.$scope.todayDate.getDate()-days));
    },

    _setTimeStamps: function(date) {
        return Math.floor(moment.utc(date).valueOf()/1000);
    }


});

eventsController.$inject = ['$scope', '$location', '$timeout', 'eventsLogService'];
window.eventsController = eventsController;
