/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*jslint plusplus: true */
/*global dashboardApp, angular, $*/

'use strict';

dashboardApp.factory('inventoryWidgetHelper',
    ['$q', 'inventoryService', '$window',
        function ($q, inventoryService, $window) {
            var helper = {};

            helper.getInventoryStats = function (data) {
                var promise = inventoryService.getInventoryStats(data).then(
                    function (result) {
                        return result;
                    },
                    function (error) {
                        // error
                    }
                );
                return promise
            };

            helper.getChartData = function (payload, data) {
                let widget;
                switch (payload.chartType) {
                    case 'bar':
                        widget = new BarWidget(payload, data);
                        break;
                    case 'pie':
                        widget = new PieWidget(payload, data);
                        break;
                    case 'solidgauge':
                        widget = new SolidGaugeWidget(payload, data);
                        break;
                    case 'table':
                        widget = new TableWidget(payload, data);
                        break;
                }
                return widget.getConfig();
            };
            return helper;
        }]
);
