policyAnalyzerApp.directive('policyFilter', function () {
    return {
        templateUrl: MP_SITE_URL + '/policy/analyzer/partials/filter',
        restrict: 'A',
        scope: {
            options: '=',
            items: '=',
            onOutcomeSelected: '&?',
        },

        link: function ($scope, element, attr) {
            $scope.selectPromiseOutcome = function (outcome) {
                $scope.onOutcomeSelected({outcome: outcome});
            }
        }
    };

});


policyAnalyzerApp.directive('chosenHostAutoComplete', ['naviTreeService', '$rootScope', function (naviTreeService, $rootScope) {
    var linker = function ($scope, element, attr) {

        if (attr.search === "false") {
            element.chosen({disable_search_threshold: 9999, width: "220px"});
        } else {
            element.chosen({width: "255px"});
        }

        var searchInput = document.querySelector(".hostFilter .chosen-search input");
        var placeholder = document.createAttribute("placeholder");
        placeholder.value = attr.placeholder;
        searchInput.setAttributeNode(placeholder);

        $scope.searchPlaceholder = 'Find host to select';
        $scope.searchCompleteSelected = {name: "All hosts", id: "%"};
        $scope.searchComplete = [{name: "All hosts", id: "%"}];

        $scope.selectHost = function (selectedValue) {
            $rootScope.$broadcast('hostSelected', selectedValue);
        };

        $scope.$on('hostFilterCleared', function () {
            $scope.searchCompleteSelected = {name: "All hosts", id: "%"};
        })

        $scope.clearSearchComplete = function () {
            $scope.searchComplete = [{name: "All hosts", id: "%"}];
        };

        $scope.$watchCollection(attr.watch, function () {
            var search_param = searchInput.value.toString();
            element.trigger('chosen:updated');
            searchInput.value = search_param;
        })

        $scope.$watch(attr.ngModel, function () {
            var search_param = searchInput.value.toString();
            element.trigger('chosen:updated')
            searchInput.value = search_param;
        })

        searchInput.onkeyup = function () {
            var search_param = searchInput.value.toString();
            if (search_param.length > 2) {
                naviTreeService.searchHosts(search_param).then(function (result) {
                    if (result.data.length > 0) {
                        $scope.clearSearchComplete();
                        result.data.forEach(function (item) {
                            $scope.searchComplete.unshift({
                                name: item.hostname,
                                id: item.hostkey
                            });
                        })

                    }
                })
            }
        };

    }
    return {
        restrict: 'A',
        link: linker
    }
}]);

policyAnalyzerApp.directive('chosen', function () {
    var linker = function (scope, element, attr) {
        if (attr.search === "false") {
            element.chosen({disable_search_threshold: 9999});
        } else {
            element.chosen();
        }

        scope.$watchCollection(attr.watch, function () {
            element.trigger('chosen:updated');
        })
        scope.$watch(attr.ngModel, function () {
            element.trigger('chosen:updated');
        })
        scope.$watch(attr.disable, function (newValue) {
            var val = newValue || false;
            element.prop('disabled', val);
            element.trigger('chosen:updated');
        })
    }
    return {
        restrict: 'A',
        link: linker
    }
});