import React from 'react';
import { Box, Link, Button } from '@mui/material';
import { makeStyles } from 'tss-react/mui';
import { isDarkMode } from '@northern.tech/store/utils';
import AIAgentIcon from './AiAgentIcon';

const useStyles = makeStyles()(theme => ({
  centeredBlock: {
    position: 'absolute',
    top: '50%',
    left: '50%',
    transform: 'translate(-50%, -50%)',
    width: 700,
  },
  notConfigured: {
    borderRadius: 4,
    background: isDarkMode(theme.palette.mode) ? theme.palette.darkBackground[500] : theme.palette.blue[50],
    padding: 16,
    textAlign: 'center',
    maxWidth: 685,
    margin: '0 auto'
  }
}));

const NotConfigured: React.FC = () => {
  const { classes } = useStyles();

  return (
    <div className={classes.centeredBlock}>
      <Box className="center margin-bottom">
        <AIAgentIcon width="58px" height="85px" />
        <h2>New! AI agent</h2>
      </Box>
      <Box className={classes.notConfigured}>
        AI features are not enabled for this organization. Go to the settings page or contact your admin to enable this feature.
        <Link sx={{ mt: 2, display: 'block' }} href="/settings/ai">
          <Button color='primary' variant='contained'>Go to settings</Button>
        </Link>
      </Box>
    </div>
  );
};

export default NotConfigured;
