import { configureStore } from '@reduxjs/toolkit';
import configReducer from '../../LlmSettings/store/configSlice';
import usersReducer from '../../../store/usersSlice';
import reportsReducer from '../../../store/reportsSlice';
import preferencesReducer from '../../../store/preferencesSlice';
import chatReducer from './chatSlice';

export const store = configureStore({
  reducer: {
    llm: configReducer,
    chat: chatReducer,
    users: usersReducer,
    reports: reportsReducer,
    preferences: preferencesReducer
  }
});

export type RootState = ReturnType<typeof store.getState>;
export type AppDispatch = typeof store.dispatch;
export { getConfig } from '../../LlmSettings/store/configSlice/thunks';
export { getRoles, getAdditionalData, updateAdditionalData } from '../../../store/usersSlice/thunks';
export { selectProfileAdditionalData } from '../../../store/usersSlice/selectors';
export { getPreferences } from '../../../store/preferencesSlice/thunks';
export { selectAIDisabled } from '../../../store/preferencesSlice/selectors';

export default store;
