import { createSlice } from '@reduxjs/toolkit';
import { getPreferences } from './thunks';

interface Preferences {
    rbacEnabled: boolean;
    ldapEnabled: boolean;
    hostIdentifier: string;
    blueHostHorizon: number;
    hostsCollisionsThreshold: number;
    logLevel: string;
    ldap_enable_role_syncing: boolean;
    ldap_perform_sync_on_login: boolean;
    ldap_remove_role_on_syncing: boolean;
    ldap_roles_list_to_sync: string;
    passwordComplexity: number;
    minPasswordLength: number;
    passwordExpirationAfterResetHours: number;
    enforce2FA: boolean;
    allowLlmViewAccessToAttributesNames: boolean;
    disableAI: boolean;
}
interface PreferencesState {
    preferences: Preferences;
    isLoading: boolean;
    error?: string | null;
}

const initialState: PreferencesState = {
    preferences: {
        rbacEnabled: true,
        ldapEnabled: false,
        hostIdentifier: "default.sys.fqhost",
        blueHostHorizon: 40 * 60, // 40 minutes
        hostsCollisionsThreshold: 3,
        logLevel: "error",
        ldap_enable_role_syncing: false,
        ldap_perform_sync_on_login: false,
        ldap_remove_role_on_syncing: false,
        ldap_roles_list_to_sync: "",
        passwordComplexity: 3,
        minPasswordLength: 8,
        passwordExpirationAfterResetHours: 48,
        enforce2FA: false,
        allowLlmViewAccessToAttributesNames: false,
        disableAI: true
    },
    isLoading: false,
    error: null
};

const preferencesSlice = createSlice({
    name: 'preferences',
    initialState,
    reducers: {},
    extraReducers: (builder) => {
        builder
            .addCase(getPreferences.pending, (state) => {
                state.isLoading = true;
                state.error = null;
            })
            .addCase(getPreferences.fulfilled, (state, action) => {
                state.isLoading = false;
                state.preferences = action.payload;
            })
            .addCase(getPreferences.rejected, (state, action) => {
                state.isLoading = false;
                state.error = action.error.message || 'Failed to fetch preferences.';
            });
    },
});

export default preferencesSlice.reducer;
