<?php

namespace CMDB\v2\Entities;

use DatabaseHelper;

final class CmdbHostEntry
{
    public function __construct(
        public readonly ?int $id = null,
        public readonly string $hostkey,
        public readonly string $type,
        public readonly string $name = '',
        public readonly string $description = '',
        public readonly array $tags = [],
        public readonly array $meta = [],
        public readonly ?array $subentries = [],
    ) {
    }

    public function toArray(): array
    {
        return [
            'hostkey' => $this->hostkey,
            'name' => $this->name,
            'description' => $this->description,
            'tags' => DatabaseHelper::toPgArray($this->tags),
            'type' => $this->type,
            'meta' => json_encode($this->meta),
        ];
    }
}
