<div ng-app="policyAnalyzerApp" id="ng-app">
    <div ng-controller="analyzerController">
        <div class="contentWrapper">
            <div class="pageTitle">
                <h1>
                    <span>Policy analyzer</span>

                    <span class="pull-right">
            <i rel="tooltip" id="tab-context-help-icon" class="CFE-context-help help icon-question-sign"
               data-title="Policy analyzer" data-key="policy-analyzer" data-placement='left'
               title="Click for help"> </i>
        </span>
                </h1>
            </div>
            <div id="filterTree" ng-init="showFilter=false" ng-class="{'open':showFilter}">
                <div class="accordion-group">
                    <div class="accordion-toggle accordion-heading" data-parent="#filterTree" data-toggle="collapse">
            <span ng-click="showFilter=!showFilter" id="filterToggle">
                <i class="icon-chevron-right" ng-show="!showFilter" style="padding: 0px 5px;"></i>
                <i class="icon-chevron-down" ng-show="showFilter" style="padding: 0px 5px;"></i>
                Filters <span ng-show="originalFilters.length" class="help-block inline"
                              style="font-size:14px; font-style:normal">({{originalFilters.length}})</span>
            </span>
                    </div>
                </div>

                <div ng-show="showFilter" class="margin-left-small margin-bottom-small">
                    <div class="margin-top margin-bottom-small border-bottom border-light" id="variableFilters">
                        <div class="inventoryfilter"
                             ui="UI"
                             sql="SQL"
                             showfilterapplybtn="true"
                        >
                        </div>
                    </div>

                    <div class="no-border"
                         id="ruleHostFilter"
                         hosts-include-exclude
                         env="hostcontexts"
                         state="hostselectionstate"
                         showenvironmentfilterbuttons="showEnvironmentFilterButtons"
                    >
                    </div>
                </div>
            </div>

            <div policy-filter
                 class="policyFilter"
                 items="promiseOutcomes"
                 on-outcome-selected="onOutcomeSelected(outcomes)"
            >
            </div>
            <div class="row-fluid">
                <div class="span4">
                    <div class="card border-secondary">
                        <div class="card-header">
                            Select file <span class="pull-right">
                        <span class="green icon-ok-sign"></span>
                        <span class="red icon-warning-sign"></span>
                        <span class="orange icon-wrench"></span>
                    </span>
                        </div>
                        <div class="card-body text-secondary">
                            <policy-file-explorer files="files"
                                                  selected-item="selectedFile"
                                                  on-file-selected="onFileSelected(file)"
                                                  on-directory-selected="onDirectorySelected(dir)"
                                                  allow-copying="allowCopying()"
                                                  node-template-id="node-template.html"
                                                  statistics="statistics"
                                                  policy-path="policyPath"
                                                  copying-enabled="copyingEnabled"
                                                  show-allow-copying-message="showAllowCopyingMessage">
                            </policy-file-explorer>
                        </div>
                    </div>
                </div>
                <div class="span8">
                    <div policy-editor
                         class="editor-area"
                         file-contents="fileContents"
                         file="selectedFile"
                         policies-info="policiesInfo"
                         policy-line-selected="selectedLine"
                    >
                    </div>
                </div>
            </div>
            <hr/>
            <div class="selected-filters"
                 ng-if="filterData.promiseOutcome.length > 0 || selectedDir.path || selectedFile.path || selectedHost.name.length > 0">
                <b>Selected filters</b>:
                <repeat ng-repeat="outcome in promiseOutcomes track by outcome.id">
                    <span ng-show="outcome.selected == true">{{outcome.name}} <button class="close"
                                                                                      ng-click="removeFilter({type: 'outcome', value: outcome.id})"><i class="bi bi-x"></i></button> </span>
                </repeat>
                <span ng-if="selectedDir.path">dir: {{selectedDir.path.relative}} <button class="close"
                                                                                          ng-click="removeFilter({type: 'dir'})"><i class="bi bi-x"></i></button> </span>
                <span ng-if="selectedFile.path">file: {{selectedFile.path.relative}} <button class="close"
                                                                                             ng-click="removeFilter({type: 'file'})"><i class="bi bi-x"></i></button> </span>
                <span ng-if="selectedHost.name.length > 0">{{selectedHost.name}} <button class="close"
                                                                                         ng-click="removeFilter({type: 'host'})"><i class="bi bi-x"></i></button></span>
            </div>

            <div policy-summary
                 class="policyTable"
                 on-line-selected="onLineSelected(line)"
                 on-file-selected="onSummaryFileSelected(file)"
                 table-data="policySummary"
                 view="VIEW"
                 sort-reorder="sortReorder(col)"
                 paginator="paginator"
            ></div>
        </div>

        <script type="text/ng-template" id="node-template.html">
            <div ng-if="isBranch(node)" ng-click="selectNode(node)" class="directory"
                 relative-path="{{node.value.path.relative}}">
      <span class="glyphicon"
            ng-class="{ 'icon-chevron-down': node.expanded, 'icon-chevron-right': !node.expanded }">
      </span>
                <span ng-class="{'selected' : node === selectedNode}">{{node.value.name}}</span>
            </div>
            <ol ng-show="node.expanded">
                <li ng-repeat="node in node.children" ng-include="'' + nodeTemplateId + ''">
            </ol>
            <div ng-if="!isBranch(node)" ng-click="selectNode(node)" class="file"
                 relative-path="{{node.value.path.relative}}" hash="{{node.value.hash}}">
                <span class="icon-file"></span>
                <span ng-class="{'selected' : node === selectedNode}">{{node.value.name}}</span>
            </div>
        </script>
    </div>
</div>
