<div ng-show="$parent.showFilter">

    <form>
        <div class="margin-bottom-small">
            <div class="btn-group filterTree">
                <a data-toggle="dropdown" class="btn btn-large dropdown-toggle">
                    <span ng-hide="selectedProfile.name">Filter on host group</span>
                    <span ng-show="selectedProfile.name">{{selectedProfile.name}}</span>
                    <span class="caret"></span>
                </a>
                <ul class="dropdown-menu">
                    <li class="select_1" ng-repeat="tree in treeProfiles" ng-click="updateTreeProfile(tree)">
                        <a href="javascript:void(0)">{{tree.name}}</a>
                    </li>
                    <li class="divider"></li>
                    <li>
                        <a href="javascript:void(0)" ng-click="addAllHostClass()">All hosts</a>
                    </li>
                </ul>
            </div>

            <div class="btn-group filterTree" ng-show="nodeLevels.length" ng-repeat="node in nodeLevels">
                <a data-toggle="dropdown" class="btn btn-large dropdown-toggle">
                    <span ng-hide="selectedNodeLevel[$index].label">Select sub-category</span>
                    <span>{{selectedNodeLevel[$index].label}}</span>
                    <span class="caret"></span>
                </a>
                <ul class="dropdown-menu">
                    <li class="select_1" ng-repeat="n in node" ng-click="addNodeLevel(n,$parent.$index)">
                        <a>{{n.label}} {{n.selected}}</a>
                    </li>
                </ul>
            </div>

            <div ng-class="{'inline':!$parent.widgetData.length}" class="margin-top report-filter">
                <span class="help-block inline" style="margin:0 16px;">or</span>

                <div class="inline-block" style="vertical-align:top">
                    <input class="input-large microcopy-search" id="classSearch" type="text" placeholder="Search" ng-model="context" ng-list />
                    <div class="microcopy help-block">matches IP addresses, host names or classes</div>
                </div>

                <div ng-class="{'border-top':$parent.widgetData.length}">
                    <div class="btn btn-large" role="button" ng-click="showHost()">Show hosts</div>
                </div>
            </div>
        </div>

        <div style="position:relative" ng-show="showenvironmentfilterbuttons">
            <div class="filter-buttons inline-block">
                <a class="margin-right-small" ng-href="" ng-click="addAllHostClass();emitClearFilters();">Clear fields</a>
                <button class="btn btn-large" ng-click="$parent.showFilter=false">Close</button>
                <button class="btn btn-large btn-primary" ng-click="applyFilter()">Apply</button>
            </div>
        </div>

        <p ng-hide="$parent.alertData" class="overflow-hidden" style="position:relative;top:20px">
            <span ng-show="env.name">Selection: <b ng-mouseover="showClassExpression=1" ng-mouseleave="showClassExpression=0" >{{env.name}}</b> <span ng-show="showClassExpression" class="muted break-word">{{env.includes}}</span></span>
        </p>

        <p class="break-word margin-top" ng-show="$parent.alertData.hostContexts">
            Selection: <span <?php /* ng-mouseover="showClassExpression=1" ng-mouseleave="showClassExpression=0" */ ?>>{{$parent.alertData.hostContexts.name}}</span> <span ng-show="showClassExpression" class="muted">{{$parent.alertData.hostContextsPath}}</span>
        </p>

    </form>

</div>

<script type="text/ng-template" id="hostSelectionModal.html">

    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"  ng-click="hostSearch =''; close()"><i class="bi bi-x"></i></button>
        <h2>Hosts list</h2>
    </div>
    <div class="modal-body no-padding">
        <div class="class-search">
            <div ng-show="totalHostList.length>0 || searchUsedFlag">
                <div class="checkbox inline checkall margin-right">
                    <label>
                        <input type="checkbox" ng-model="allchecked" ng-click="checkAllHosts()">
                        All
                    </label>
                </div>
                <label class="inline" for="host_search">
                    <input
                        class="no-margin"
                        type="text"
                        id="host_search"
                        ng-model="hostSearch.input"
                        placeholder="Search"
                        ng-keyup="runHostSearch($event)"
                        >
                </label>
            </div>
             <div ng-show="!showHosts">Loading hosts.. please wait</div>
            <div ng-show="showHosts&&totalHostList.length == 0">
                <p>Sorry, no hosts matched your criteria</p>
            </div>
        </div>

        <div class="host-list" ng-show="totalHostList.length>0">

            <ul class="unstyled">
                <li ng-repeat="host in totalHostList">
                    <div class="checkbox">
                        <label>
                            <input class="host-selector" type="checkbox" ng-click="hostMarkAsSelected(host)" value='host.id' checked>
                            {{host.hostname}}
                            {{$parent.environment.selectedHosts[host.id]['selected']}}
                        </label>
                    </div>
                </li>
            </ul>
        </div>

    </div>
    <div class="modal-footer">
        <button class="btn btn-large" data-dismiss="modal" ng-click="hostSearch =''; close()" >Close</button>
        <button class="btn btn-large btn-primary" ng-disabled="disableButton()" ng-hide="totalHostList.length==0" ng-click="useSelectedHost()">Use selected hosts</button>
    </div>
</script>
