<?php

class SharedGroupCmdbEntryFactory
{
    public static function fromRequest(array $data, string $group_id): SharedGroupCmdbEntry
    {
        $subentries = array_map(function ($subentry) use ($group_id): SharedGroupCmdbSubEntry {
            return new SharedGroupCmdbSubEntry(
                id: null,
                entry_id: null,
                group_id: $group_id,
                item_name: $subentry['item_name'] ?? '',
                item_type: $subentry['item_type'] ?? '',
                item_value: $subentry['item_value'] ?? null,
            );
        }, ($data['entries'] ?? []));

        return new SharedGroupCmdbEntry(
            id: null,
            group_id: $group_id,
            name: $data['name'] ?? '',
            description: $data['description'] ?? '',
            tags: $data['tags'] ?? [],
            type: $data['type'] ?? '',
            meta: $data['meta'] ?? [],
            subentries: $subentries
        );
    }
}
