<?php


class SettingsAuthenticationImporter extends BaseDataImporter
{
    public function isOnlyForAdmin(): bool
    {
        return true;
    }

    public function import($data)
    {
        if (isset($data) && !empty($data) && isset($this->phar[$data])) {
            $ldapConfigPath = FCPATH . '/ldap/config/settings.ldap.php';
            $content = $this->phar[$data]->getContent();
            $content = $this->ci->cf_encrypt->decryptByKey($content, $this->encryptionKey);
            if ($content) {
                file_put_contents($ldapConfigPath, $content);
                log_audit(
                    actor: $this->username,
                    objectType: AUDIT_LOG_TYPE_SETTINGS,
                    action: AUDIT_LOG_ACTION_UPDATE,
                    objectName: AUDIT_LOG_AUTHENTICATION_SETTINGS_NAME,
                    details: ['Updated authentication settings via Import.']
                );
            }
        }
    }
}
