class BarWidget extends BaseBarPieWidget {
    constructor(payload, data) {
        super(payload, data);
        this.config = {
            chart: {
                type: 'bar',
                events: {
                    click: this.clickAction.bind(this)
                },
                attribute: '',
                backgroundColor: 'transparent'
            },
            exporting: {
                enabled: false
            },
            plotOptions: {
                column: {
                    allowPointSelect: false,
                    cursor: 'pointer'
                },
                series: {
                    borderWidth: 0,
                    color: widgetColors.mainColor(),
                    dataLabels: {
                        enabled: true,
                        format: '{point.y}'
                    },
                    events: {
                        click: function (event) {
                            const clickAction = this.clickAction(event, event.point.category);
                            if (clickAction != undefined) {
                                clickAction.call(this);
                            }
                        }.bind(this)
                    },
                }
            },
            tooltip: {
                formatter: function () {
                    return this.x + ': ' + this.y;
                }
            },
            legend: {
                enabled: false,
            },
            series: [{
                data: []
            }],
            subtitle: {
                text: ''
            },
            title: {
                text: '',
                align: 'left'
            },
            xAxis: {
                categories: [],
                title: {
                    text: null
                },
                allowDecimals: false,
                labels: {
                    style: {
                        fontWeight: "500",
                        fontSize: "11px",
                        color: "#7C7C7C"
                    },
                    formatter: function () {
                        return this.value.length > 16 ? (this.value.substring(0, 16) + "...") : this.value;
                    }
                }
            },
            yAxis: {
                title: {
                    text: ''
                },
                labels: {
                    overflow: 'justify'
                }
            },
            credits: {
                enabled: false
            },
            loading: false
        };
    }

    getConfig() {
        let barConvertedData = this.barConvertArray(this.data);
        this.config.series[0] = {
            data: barConvertedData.array
        };
        this.config.xAxis.categories = barConvertedData.axis;
        this.config.yAxis.title.text = 'Hosts | Total: ' + barConvertedData.total;
        this.config.chart.attribute = this.variable;
        return this.config;
    }

    barConvertArray(arr) {
        let returnData = {};
        returnData.array = [];
        returnData.axis = [];
        returnData.total = 0;
        angular.forEach(arr.data, function (value, key) {
            returnData.array.push(value);
            returnData.total += value;
            returnData.axis.push(key);
        });
        return returnData;
    };
}
