<p ng-show="!alertData.id" class="help-block">Create a new alert to add to the widget<span ng-show="widgetData.name"> "{{widgetData.name}}"</span>.</p>

<form name="alertForm" class="form-horizontal compliance-form" style="overflow:visible" novalidate>
    <div ng-form="nameForm" class="control-group required" ng-class="{error:alertEdit.$dirty && (nameForm.alert_name.$invalid || nameForm.alert_name.$error.required)}">
        <label class="control-label">
            <span>Alert name</span>
        </label>

        <div class="controls">
            <input type="text" name="alert_name" ng-model="alertData.name" maxlength="100" required>
            <span class="help-block" ng-hide="alertEdit.$dirty && (nameForm.alert_name.$invalid || nameForm.alert_name.$error.required)">Unique name for the alert.</span>
            <span class="help-block error" ng-show="alertEdit.$dirty && (nameForm.alert_name.$invalid || nameForm.alert_name.$error.required)">You must name the alert.</span>
        </div>
    </div>

    <!-- Severity  -->

    <div ng-form="sevForm" class="control-group required" ng-class="{error:alertEdit.$dirty && !alertData.severity}">
        <label class="control-label">
            <span>Severity</span>
        </label>

        <div class="controls">
            <select
                required
                data-placeholder="Select severity"
                chozen
                name="sev_level"
                ng-init="alertData.severity='medium'"
                ng-model="alertData.severity"
                watch="DCA.Severity_dropDown"
                ng-options="item.value as item.label for item in DCA.Severity_dropDown"
                >
            </select>
            <span class="help-block error" ng-show="alertEdit.$dirty && sevForm.sev_level.$error.required">You must assign a level of severity to the alert.</span>
        </div>
    </div>
</form>
