<form id="verify-2f-form" class="verify-wrapper form-horizontal">
    <div style="padding: 16px">
        <div class="control-group required">
            <label class="control-label" for="code">Authentication code</label>
            <div class="controls">
                <input placeholder="xxxxxx" autocomplete="off"  id="code" type="text" name="code" class="code-input" maxlength="6" value="">
            </div>
        </div>
        <div style="margin-left: 44px">Open your authentication app on your device to retrieve the code.</div>
    </div>

    <div class="modal-footer">
        <button type="submit" class="btn btn-small btn-primary">Verify</button>
        <button class="btn btn-close" type="button" data-dismiss="modal">
            Cancel
        </button>
    </div>
</form>

<script>
    $('#verify-2f-form').validate({
        rules: {
            code: {
                required: true,
                digits: true,
                minlength: 6,
                maxlength: 6,
            }
        },
        messages: {
            code: {
                required: "Please enter authentication code",
                minlength: "Authentication code should be 6 digits long",
            }
        },
        errorPlacement: function (error, [element]) {
            error.insertAfter(element.parentNode.querySelector('.code-input'));
            error.attr('title', error.text());
        },
        highlight: function (element, error, eee, fff) {
            const errorContainer = element.parentNode.querySelector('label.error');
            if (errorContainer) {
                errorContainer.title = errorContainer.innerText;
            }
        },
        submitHandler: function (form) {
            twoFa.verify2Fa(document.querySelector('.code-input').value);
        }
    });
</script>
