<?php

/**
 * Class HostsNeverCollectedSqlBuilder
 */
class HostsNeverCollectedSqlBuilder extends BaseHealthDiagnosticSqlBuilder
{
    /**
     * @var string
     */
    protected $sql = 'SELECT hostkey FROM hosts_not_reported WHERE hostkey NOT IN (SELECT hostkey FROM health_diagnostics_dismissed WHERE username = \'%s\' AND report_type = \'%s\' )';

    /**
     * @var string
     */
    protected $nonOverlappedSql;

    /**
     * @var string
     */
    protected $reportSql = 'SELECT h.Hostkey as key,h.Hostkey as hostkey, ipaddress as "IP address", lastreporttimestamp as "Last report collected", firstreporttimestamp as "First report collected"
                            FROM hosts_not_reported h';


    /**
     * @return string
     */
    public function getSql(): string
    {
        $sql = sprintf($this->sql, $this->userName, BaseHealthDiagnostic::HOSTS_NEVER_COLLECTED_TYPE);
        return $sql;
    }

    /**
     * Return report sql
     *
     * @return string
     */
    public function getReportSql(): string
    {
        /**
         * Extend report sql by adding where in (report sql).
         * It needs to include in report only needed hosts.
         */
        $this->reportSql = sprintf($this->reportSql . ' WHERE HostKey IN (%s)', $this->getNonOverlappedSql());

        return $this->reportSql;
    }

}
