<?php

class Modules_model extends Cf_Model
{
    private $endpoint = '/build/modules';

    public function list(array $params = [])
    {
        $query = http_build_query($params);
        return $this->getRestClient()->get("{$this->endpoint}?$query");
    }

    public function refresh_list()
    {
        return $this->getRestClient()->post($this->endpoint);
    }

    public function getByName(string $name, $version = null)
    {
        $url = "{$this->endpoint}/$name/";
        if ($version != null) {
            $url .= "{$version}/";
        }
        return $this->getRestClient()->get($url);
    }
}
