<?php

require_once APPPATH . '/libraries/Cf_REST_Controller.php';

/*
Hight avaliability controller
*/
class HighAvailability extends Cf_REST_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->username = $this->session->userdata('username');
        $this->load->model('high_availability_model');
        $this->load->library('Setting_lib');
        $this->high_availability_model->setRestClient($this->getRestClient());
    }


    /**
     * Return info about high availability functionality
     *
     * Note -include/exclude should not supported here!
     *
     */
    function status_get()
    {
        // change to ha_status file
        $filename = FCPATH.'ha_enabled';

        if (file_exists($filename))
        {
            try
            {
                $data = $this->high_availability_model->getHAstatus($this->username);
                $this->respond_ok(json_encode($data));
            }
            catch (Exception $e)
            {
                log_message(log_level_for_exception($e),'Error getting High Availability status with message :: '. $e->getMessage());
                $this->respond_internal_error('Error getting connectivity status.');
            }
        }
        else
        {
            // HA not set up
            $data = array('status' => 'not_active');
            $this->respond_ok(json_encode($data));
        }

    }

    function threshold_get()
    {
        // gets the blue host threshold time from the settings
        $this->load->model('settings_rest_model');
        $settings = $this->settings_rest_model->get_app_settings();
        $timeCheckForBlueHost = $settings['blueHostHorizon'];
        $this->respond_ok(json_encode($timeCheckForBlueHost));
    }
}
