<?php

class DashboardsImporter extends BaseDataImporter
{
    private $dashboards = [];
    private $widgets = [];
    private $rules = [];
    private $alerts = [];
    private $scripts = [];

    public function isOnlyForAdmin(): bool
    {
        return false;
    }

    public function import($data)
    {
        $data = json_decode($data, JSON_OBJECT_AS_ARRAY);
        $this->importDashboards($data['dashboard_dashboards']);
        $this->importWidgets($data['dashboard_widgets']);
        $this->importRules($data['dashboard_rules']);
        $this->importAlerts($data['dashboard_alerts']);
        $this->importScripts($data['dashboard_scripts']);
        $this->importAlertScripts($data['dashboard_alerts_script']);
    }

    private function importDashboards($dashboards)
    {
        foreach ($dashboards as $dashboard) {
            //set current user name in case of non admin user
            $dashboard['username'] = $this->isAdmin === true ? $dashboard['username'] : $this->username;

            $this->db->reset_query();
            $filter = [
                'name' => $dashboard['name'],
                'username' => $dashboard['username']
            ];

            $exist = $this->db->get_where('dashboard_dashboards', $filter);

            $oldId = $dashboard['id'];
            unset($dashboard['id']);
            if ($exist->num_rows() == 0) {
                $this->db->insert('dashboard_dashboards', $dashboard);
                $this->dashboards[$oldId] = ['id' => $this->db->insert_id()];
            } elseif ($this->skipDuplicates == 0) {
                $this->db->update('dashboard_dashboards', $dashboard, $filter);
                $this->dashboards[$oldId] = ['id' => $exist->row()->id];
            }
        }
    }

    private function importWidgets($widgets)
    {
        foreach ($widgets as $widget) {

            //set current user name in case of non admin user
            $widget['username'] = $this->isAdmin === true ? $widget['username'] : $this->username;

            $oldId = $widget['id'];
            $oldDashboardId = $widget['dashboardid'];
            unset($widget['id']);
            // if widget
            if (in_array($widget['dashboardid'], array_keys($this->dashboards))) {
                //change old dashboard id to new
                $widget['dashboardid'] = $this->dashboards[$oldDashboardId]['id'];

                $filter = [
                    'name' => $widget['name'],
                    'dashboardid' => $widget['dashboardid']
                ];

                $exist = $this->db->get_where('dashboard_widgets', $filter);

                if ($exist->num_rows() == 0) {
                    $this->db->insert('dashboard_widgets', $widget);
                    $newWidgetId = $this->db->insert_id();
                    $this->dashboards[$oldDashboardId]['widgets'][] = $newWidgetId;
                    $this->widgets[$oldId] = ['id' => $newWidgetId];
                } elseif ($this->skipDuplicates == 0) {
                    $this->db->update('dashboard_widgets', $widget, $filter);
                    $this->dashboards[$oldDashboardId]['widgets'][] = $exist->row()->id;
                    $this->widgets[$oldId] = ['id' => $exist->row()->id];
                }

            }
        }

        /**
         * update dashboard widgets
         */
        foreach ($this->dashboards as $dashboard) {
            $widgets = $this->db->query('SELECT string_agg(id::text, \',\') as widgets FROM dashboard_widgets WHERE dashboardid = ' . $dashboard['id'])->row();
            if ($widgets->widgets != null) {
                $this->db->reset_query();
                $this->db->set('widgets', $widgets->widgets);
                $this->db->where('id', $dashboard['id']);
                $this->db->update('dashboard_dashboards');
            }
        }

    }

    private function importRules($rules)
    {
        foreach ($rules as $rule) {

            //set current user name in case of non admin user
            $rule['username'] = $this->isAdmin === true ? $rule['username'] : $this->username;

            $rule['conditionmustbemet'] = $rule['conditionmustbemet'] == 1 ? 'true' : 'false';

            $this->db->reset_query();
            $filter = [
                'name' => $rule['name'],
                'username' => $rule['username']
            ];
            $exist = $this->db->get_where('dashboard_rules', $filter);

            $oldId = $rule['id'];
            unset($rule['id']);
            if ($exist->num_rows() == 0) {
                $this->db->insert('dashboard_rules', $rule);
                $this->rules[$oldId] = ['id' => $this->db->insert_id()];
            } elseif ($this->skipDuplicates == 0) {
                $this->db->update('dashboard_rules', $rule, $filter);
                $this->rules[$oldId] = ['id' => $exist->row()->id];
            } else {
                $this->rules[$oldId] = ['id' => $exist->row()->id];
            }
        }
    }

    private function importAlerts($alerts)
    {
        foreach ($alerts as $alert) {
            //set current user name in case of non admin user
            $alert['username'] = $this->isAdmin === true ? $alert['username'] : $this->username;

            $oldId = $alert['id'];
            $oldRuleId = $alert['ruleid'];
            $oldWidgetId = $alert['widgetid'];

            unset($alert['id']);
            if (in_array($oldWidgetId, array_keys($this->widgets))) {
                $alert['ruleid'] = $this->rules[$oldRuleId]['id'];
                $alert['widgetid'] = $this->widgets[$oldWidgetId]['id'];


                $filter = [
                    'name' => $alert['name'],
                    'username' => $alert['username'],
                    'widgetid' => $alert['widgetid']
                ];
                $exist = $this->db->get_where('dashboard_alerts', $filter);

                if ($exist->num_rows() == 0) {
                    $this->db->insert('dashboard_alerts', $alert);
                    $this->alerts[$oldId] = ['id' => $this->db->insert_id()];
                } elseif ($this->skipDuplicates == 0) {
                    $this->db->update('dashboard_alerts', $alert, $filter);
                    $this->alerts[$oldId] = ['id' => $exist->row()->id];
                }
            }
        }
    }

    private function importScripts($scripts)
    {
        if ($this->isAdmin === false) {
            return true;
        }

        $this->saveScripts();
        foreach ($scripts as $script) {
            $this->db->reset_query();
            $filter = ['name' => $script['name']];
            $exist = $this->db->get_where('dashboard_scripts', $filter);
            $oldId = $script['id'];
            unset($script['id']);
            if ($exist->num_rows() == 0) {
                $this->db->insert('dashboard_scripts', $script);
                $this->scripts[$oldId] = ['id' => $this->db->insert_id()];
            } elseif ($this->skipDuplicates == 0) {
                $this->db->update('dashboard_scripts', $script, $filter);
                $this->scripts[$oldId] = ['id' => $exist->row()->id];
            } else {
                $this->scripts[$oldId] = ['id' => $exist->row()->id];
            }
        }
    }

    private function importAlertScripts($scripts)
    {
        if ($this->isAdmin === false) {
            return true;
        }

        foreach ($scripts as $script) {

            $data = [
                'alert_id' => $this->alerts[$script['alert_id']]['id'],
                'script_id' => $this->scripts[$script['script_id']]['id']
            ];

            if (in_array($script['alert_id'], array_keys($this->alerts))) {
                $this->db->insert('dashboard_alerts_script', $data);
            } elseif ($this->skipDuplicates == 0) {
                $where = [
                    'alert_id' => $script['alert_id'],
                    'script_id' => $script['script_id']
                ];
                $this->db->update('dashboard_alerts_script', $data, $where);
            }
        }
    }

}
