angular.module('selectFileDirective', [])
    .directive('selectFile', ['$rootScope', function ($rootScope) {
        return {
            restrict: 'A',
            scope: {
                config: '='
            },
            link: function (scope, element, attrs) {
                element.bind('change', function () {
                    let fileReader = new FileReader();
                    const file = this.files[0];
                    fileReader.onload = () => {
                        let content = fileReader.result;
                        $rootScope.$broadcast('FILE_SELECTED', {content, name: file.name});
                    }
                    fileReader.readAsText(file);
                });
            }
        };
    }]);
