<?php

/*
 * Full events log
 *
 */

?>
<div class="contentWrapper">
    <div class="pageTitle">
        <h1>
            <span>Event log</span>
            <div class="search-in-normal-view">
                <input type="text" placeholder="Search" ng-model="searchEvents" ng-change="delaySearch()">
                <a class="clear-search" ng-class="{'no-width':!searchEvents}" ng-click="searchEvents='';search();"></a>
            </div>
        </h1>
    </div>

    <div class="overflow-hidden">
        <label class="pull-left">
         <select name="type"
                 ng-model="type.selectedOption"
                 ng-options="option.name for option in type.availableOptions track by option.id"
         >

         </select>
            <span class="micro-copy help-block">Filter by type</span>
        </label>
        <label class="pull-right">
            <input
                date-range-picker
                class="form-control date-picker pull-right"
                type="text"
                ng-model="myDateRange"
                options="dateOpts"
                max="todayDate"
            >
            <span class="micro-copy help-block">Filter by date</span>
        </label>
    </div>


    <div class="alert alert-warning" ng-hide="eventsLog.length">No events found</div>

    <div ng-show="eventsLog.length">
        <div class="btn-group pull-right">
            <a data-toggle="dropdown" class="btn dropdown-toggle">
                <span>{{pageSize}}</span>
                <span class="caret"></span>
            </a>
            <ul class="dropdown-menu dropup">
                <li ng-repeat="size in DCA.Page_size">
                    <a ng-click="setPageSize(size)" href="javascript:void(0)">{{size}}</a>
                </li>
            </ul>
        </div>

        <div class="inline pagination pull-right">
            <pagination previous-text="«" next-text="»" max-size="maxSize" ng-model="currentPage" ng-change="pageChanged()" class="pagination-sm" direction-links="numPages>3" boundary-links="numPages>5" rotate="false" total-items="totalItems" page="currentPage" items-per-page="pageSize" num-pages="numPages"></pagination>
        </div>

        <div class="pull-left">
            <div ng-show="(currentPage === numPages) && currentPage > 1">
                Showing {{totalItems % pageSize || pageSize}} of {{totalItems}} results on {{numPages}} page<span hide="numPages>1">s</span>
            </div>
            <div ng-hide="(currentPage === numPages) && currentPage > 1">
                Showing {{Math.min(pageSize,totalItems)}} of {{totalItems}} results on {{numPages}} page<span hide="numPages>1">s</span>
            </div>
        </div>

        <table class="table table-horizontal float-left margin-top">
            <thead>
                <tr>
                    <th>Time</th>
                    <th>Source</th>
                    <th>Description</th>
                </tr>
            </thead>
            <tbody>
                <tr ng-switch on="event.item_type" ng-repeat="event in eventsLog" id="{{event.id}}">

                    <td class="no-wrap">{{event.time | convertTime}}</td>
                    <td class="no-wrap" ng-switch-when="alerts">
                        <a ng-href="/dashboard/{{event.item_type}}/result/{{event.item_id}}">
                           Alert "{{event.item_name}}"
                        </a>
                    </td>
                    <td class="no-wrap upper-first" ng-switch-when="script">
                        {{event.item_type}} "{{event.item_name}}"
                    </td>
                    <td class="no-wrap upper-first" ng-switch-default>
                        {{event.item_type}} "{{event.item_name}}"
                    </td>
                    <td>{{event.message}}</td>
                </tr>
            </tbody>
        </table>

        <div class="margin-bottom">

            <div class="btn-group pull-right">
                <a data-toggle="dropdown" class="btn dropdown-toggle">
                    <span>{{pageSize}}</span>
                    <span class="caret"></span>
                </a>
                <ul class="dropdown-menu dropup">
                    <li ng-repeat="size in DCA.Page_size">
                        <a ng-click="setPageSize(size)" href="javascript:void(0)">{{size}}</a>
                    </li>
                </ul>
            </div>

            <div class="inline pagination pull-right">
                <pagination previous-text="«" next-text="»" max-size="maxSize" ng-model="currentPage" ng-change="pageChanged()" class="pagination-sm" direction-links="numPages>3" boundary-links="numPages>5" rotate="false" total-items="totalItems" page="currentPage" items-per-page="pageSize" num-pages="numPages"></pagination>
            </div>

            <div class="pull-left">
                <div ng-show="(currentPage === numPages) && currentPage > 1">
                    Showing {{totalItems % pageSize || pageSize}} of {{totalItems}} results on {{numPages}} page<span hide="numPages>1">s</span>
                </div>
                <div ng-hide="(currentPage === numPages) && currentPage > 1">
                    Showing {{Math.min(pageSize,totalItems)}} of {{totalItems}} results on {{numPages}} page<span hide="numPages>1">s</span>
                </div>
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
</div>
