import React from 'react';
import { Box, Stack, Chip } from '@mui/material';
import { makeStyles } from 'tss-react/mui';
import AIAgentIcon from './AiAgentIcon';
import InputArea from './InputArea';

const useStyles = makeStyles()(theme => ({
  centeredBlock: {
    position: 'absolute',
    top: '50%',
    left: '50%',
    transform: 'translate(-50%, -50%)',
    width: 700,
  }
}));

const QUESTIONS_EXAMPLES = [
  'Hosts that have SSH port open',
  'Hosts with uptime less than 1 week',
  'Hosts with OpenSSL version 1.0.2'
];

interface InitialScreenProps {
  inputValue: string;
  isLoading: boolean;
  onSendMessage: (message: string) => void;
  onCancelRequest: () => void;
  onInputChange: (value: string) => void;
}

const InitialScreen: React.FC<InitialScreenProps> = ({
  inputValue,
  isLoading,
  onSendMessage,
  onCancelRequest,
  onInputChange
}) => {
  const { classes } = useStyles();
  return (
    <Box className={classes.centeredBlock}>
      <Box className="center margin-bottom">
        <AIAgentIcon width="58px" height="85px" />
        <h2>Hi, how can I help?</h2>
      </Box>
      <Box>
        <InputArea isLoading={isLoading} inputValue={inputValue} onSendMessage={onSendMessage} onCancelRequest={onCancelRequest} onInputChange={onInputChange} />
        <Stack direction="row" justifyContent="center" spacing={1} sx={{ margin: '28px auto' }}>
          {QUESTIONS_EXAMPLES.map(question => (
            <Chip
              key={question}
              label={question}
              onClick={() => onSendMessage(question)}
            />
          ))}
        </Stack>
      </Box>
    </Box>
  );
};

export default InitialScreen;
