<?php

abstract class HttpClientBase
{
    /**
     * @var string Base Url
     */
    protected $baseURL;

    /**
     * HttpClientBase constructor.
     * @param $baseURL
     */
    public function __construct($baseURL)
    {
        $this->baseURL = $baseURL;
    }

    /**
     * @return mixed
     */
    public function getBaseUrl()
    {
        return $this->baseURL;
    }


    /**
     * @param $url
     * @param $data
     * @param array $headers
     * @return mixed
     */
    abstract public function post($url, $data, $headers = []);

    /**
     * @param $url
     * @param $data
     * @param array $headers
     * @return mixed
     */
    abstract public function get($url, $data, $headers = []);

    /**
     * @param $url
     * @param $data
     * @param array $headers
     * @return mixed
     */
    abstract public function put($url, $data, $headers = []);

    /**
     * @param $url
     * @param $data
     * @param array $headers
     * @return mixed
     */
    abstract public function delete($url, $data, $headers = []);

}
