'use strict';
/*common functions */


reports.factory('commonHelper', ['$rootScope', '$location', 'reportService', 'wizardSharedService', 'notificationService', 'modalWindowService', function($rootScope, $location, reportService, wizardSharedService, notificationService, modalWindowService) {
    var helper = {};

    /**
     * Convert DCA into array
    */
    helper.convertDCA_TO_ARRAY = function($arr) {
        var tmp    = [];
        var result = [];

        tmp = angular.copy($arr)
        angular.forEach(tmp, function(field, key){
            result.push(field);
        });

        return result;
    };
    /**
     * Creste array based on converted DCA with tableId as key
     */
    helper.groupConvertedDCAbyTable = function($arr) {
        var $result = {};

        angular.forEach($arr, function(table, key){

            if ($result[table['TableID']] === undefined) {
                $result[table['TableID']] = {};
                $result[table['TableID']]['TableID'] = table['TableID'];
                $result[table['TableID']]['label']   = table['label'];
                $result[table['TableID']]['Fields']  = [];
            }

            angular.forEach(table.Fields, function(field, itemId){
               $result[table['TableID']]['Fields'].push(field);
            });
        });

        return $result;
    };

    /**
     * Add hub id column to DCA object
     */
    helper.includeHubIdIntoDCA = function() {
        Object.keys(DCA_TABLES).forEach(function (tableName, index) {
            DCA_TABLES[tableName].Fields[tableName + '.Hub_Id'] = {
                dataType: "real",
                inputType: "text",
                label: "Hub id",
                name: "Hub_Id",
                sqlField: tableName + ".Hub_Id",
                table: tableName
            };
        });
    };

    /**
     *  Connect DCA_TABLES fields with predefinde options, like color
     *
     *  disabled
     */
/*    helper.prepareDCA = function() {
        angular.forEach(DCA, function(field, key){
            if(field.inputType == 'select') {
                // TODO: check if inArray walk only through the array keys, without recursion
                if (jQuery.inArray(field.defaultData, customOptions)) {
                    field.options = customOptions[field.defaultData];
                }
            }
        });
    }
*/


    /*
     * Remove  values from dropdown fields which shouldn't be saved in DB - oposite to the prepareDCA()
     *
     * disabled
     */
/*
    helper._cleanUpDataBeforeModelStateSave1 = function($scope) {
        var sql_scopes = ['fields', 'filters', 'orderby', 'groupby']
        var i = 0;

        for (i=0; i<sql_scopes.length; i++) {
            angular.forEach($scope.SQL[sql_scopes[i]], function(field, key) {
                if(field.inputType == 'select') {
                    // TODO: check if inArray walk only through the array keys, without recursion
                    if (jQuery.inArray(field.defaultData, customOptions)) {
                        field.options = [];
                    }
                }
            });
        }
        return;
    };
*/

    // Check if object is empty
    // return true if object is empty
    helper._isObjEmpty = function(o)
    {
        for(var p in o) {
            if (o[p] != o.constructor.prototype[p]) {
                return false;
            }
        }
        return true;
    };

    /**
     *  Save report.
     *  This function workds with "scope" from called controller
     *
     *  callerScope   - parent scope
     *
     *  callerPageAction -  page to redirect after saving report
     *
     */

    helper.saveReport = function(isOverwrite, callerScope, callerPageAction) {
        var overwrite   = (isOverwrite !== true ? false : true);

        notificationService.resetNotification();
        var formData = {};

        var SQLTOSAVE = angular.copy(callerScope.SQL);

        // do not save environment stuff
        delete SQLTOSAVE.hostcontexts;
        delete SQLTOSAVE.hostcontextsprofileid;
        delete SQLTOSAVE.hostcontextspath;
        delete SQLTOSAVE.excludedHosts;

        formData.SQL = angular.toJson(SQLTOSAVE);
        formData.noResultsSuccess = callerScope.noResultsSuccess || false;
        var data = $.param({
            report_title  : 'Advanced reports',
            id            : callerScope.reportId != undefined ? callerScope.reportId : null,
            type          : callerScope.reportType != undefined ? callerScope.reportType : 'advanced',
            search_name   : callerScope.savedSearchName.input,
            reportCategory : callerScope.savedSearchCategory.input,
            search_url    : 'advancedreports',
            search_params : encodeURIComponent(SQLTOSAVE.SQLSTRING),
            overwrite     : overwrite,
            sharedPermission    : angular.toJson(callerScope.reportRoles),
            AdvancedReportsData : formData,
            is_public : (callerScope.is_public !== undefined && callerScope.is_public.input === true ? true: false)
        });


        return reportService.saveReport(data).then(
            function(result) {
                notificationService.setNotification('success', result.data);
                if (callerScope.modalWindow != undefined && callerScope.modalWindow.isOpen) {
                    callerScope.modalWindow.close('saveSearchModal');
                }

                callerScope.reportLabel = callerScope.savedSearchName.input;
                callerScope.reportId    = result.data[0].reportId;
                callerScope.showOverwrite = false;

                $rootScope.$broadcast('saveReport_saveSuccess_Event');
                if (callerPageAction === '')
                {
                    wizardSharedService.reportPropertiesChanged(helper.getReportData(callerScope));
                }
                else
                {
                    switch(callerPageAction)
                    {
                        case 'edit':    wizardSharedService.resetScope();           $location.path('/custom/edit/' + encodeURIComponent(callerScope.reportId)); break;
                        case 'result':  wizardSharedService.resetScope();           $location.path('/report/run/'  + encodeURIComponent(callerScope.reportId)); break;
                        case 'inventory-result': wizardSharedService.resetScope();  $location.path('/inventory/run/'  + encodeURIComponent(callerScope.reportId)); break;
                        case 'changes-result': wizardSharedService.resetScope();  $location.path('/changes/run/'  + encodeURIComponent(callerScope.reportId)); break;
                        case 'compliance': wizardSharedService.resetScope();  $location.path('/compliance/run/'  + encodeURIComponent(callerScope.reportId)); break;
                        default: var error = notificationService.createObjectForNotification('error', 500, 'Unknown action. Please refresh the page');
                                  notificationService.setNotification(error.type, error.data);
                    }
                }
            },
            function(error) {
                notificationService.setNotification('error', error.data);
                if(error.data[0]['errorCode'] === 422) {
                  callerScope.showOverwrite = true;
                }
            });
    };


    helper.getReportData = function(callerScope)
    {
        var arr = {};
        arr.reportId       = (callerScope.reportId        !== undefined ? callerScope.reportId    : '' );
        arr.reportLabel    = (callerScope.reportLabel     !== undefined ? callerScope.reportLabel : '' );
        arr.reportCategory = (callerScope.reportCategory  !== undefined ? callerScope.reportCategory : '' );
        arr.reportRoles    = (callerScope.reportRoles     !== undefined ? callerScope.reportRoles : {} );

        arr.hostcontexts          = (callerScope.hostcontexts          !== undefined ? callerScope.hostcontexts : {});
        arr.hostcontextsprofileid = (callerScope.hostcontextsprofileid !== undefined ? callerScope.hostcontextsprofileid : '');
        arr.hostcontextspath      = (callerScope.hostcontextspath      !== undefined ? callerScope.hostcontextspath : '');
        arr.excludedHosts         = (callerScope.excludedHosts         !== undefined ? callerScope.excludedHosts : {});

        arr.can_edit    = (callerScope.can_edit     !== undefined ? callerScope.can_edit    : '' );
        arr.can_delete  = (callerScope.can_delete   !== undefined ? callerScope.can_delete  : '' );
        arr.is_own      = (callerScope.is_own       !== undefined ? callerScope.is_own      : '' );
        arr.readonly    = (callerScope.readonly     !== undefined ? callerScope.readonly    : '' );

        arr.is_public   = (callerScope.is_public    !== undefined ? callerScope.is_public   : '' );
        arr.noResultsSuccess = (callerScope.noResultsSuccess !== undefined ? callerScope.noResultsSuccess : '');
        return arr;
    };



     helper.restoreReportLabel=function() {
        var data = wizardSharedService.restoreReportProperties();
        var label = '';
        // do not restore report id, because user can edit saved search and then press run,
        // and we must keep current state, not the original from DB
        if (data !==undefined)
        {
            label = (data.reportLabel !== undefined ? data.reportLabel : '');
        }

        return label;
    }


   helper.restoreReportCategory=function() {
        var data = wizardSharedService.restoreReportProperties();
        var category = '';
        // do not restore report id, because user can edit saved search and then press run,
        // and we must keep current state, not the original from DB
        if (data !==undefined)
        {
            category = (data.reportCategory !== undefined ? data.reportCategory : '');
        }

        return category;
    };

    helper.restoreReportId = function() {
        var data = wizardSharedService.restoreReportProperties();
        var reportId = '';

        if (data !==undefined)
        {
            reportId = (data.reportId !== undefined ? data.reportId : '');
        }
        return reportId;
    };

    /**
     * return roles assigned to report - sharedPermission
     */
    helper.restoreReportRoles = function() {
        var data = wizardSharedService.restoreReportProperties();
        var reportRoles = '';

        if (data !==undefined)
        {
            reportRoles = (data.reportRoles !== undefined ? data.reportRoles : '');
        }
        return reportRoles;
    };

    /**
     * return all roles available to user.
     *
     * userRoles - global variable in index.php - array, and we should convert it to [key] = value
     */
    helper.getRolesArray = function() {
        var result = {};
        angular.forEach(userRoles, function(field, itemId){
               result[field] = field;
            });
        return result;
    };

    helper.roles_disablePublicReport = function(publicCheckbox, callerScope)
    {
        angular.forEach(callerScope.reportRoles, function(data, item){
            if (callerScope.reportRoles[item] === true)
            {
                callerScope.is_public.input=false;
            }
        });
    };

    helper.publicReport_disableRoles = function(publicCheckbox, callerScope)
    {
        if (publicCheckbox === true)
        {
              angular.forEach(callerScope.reportRoles, function(data, item){
                 callerScope.reportRoles[item] = false;
              });
        }
    };

    helper.subscribeToReport = function(id) {

        var paramsToSend = {};

            paramsToSend.reportId = id;

        var data = $.param(paramsToSend);

        if (id !== '')
        {
           reportService.subscribeToReport(data).then(
            function(result) {
                notificationService.setNotification('success', result.data);
                $rootScope.$broadcast('subscribeToReport', {'id': id});
            },
            function(error) {
                notificationService.setNotification('error', error.data);
            });
        }
    };

    helper.unSubscribeFromReport = function(id) {
        var paramsToSend = {};
            paramsToSend.reportId = id;

        var data = $.param(paramsToSend);

        if (id !== '')
        {
           reportService.unsubscribeFromReport(data).then(
            function(result) {
                notificationService.setNotification('success', result.data);
                $rootScope.$broadcast('unSubscribeFromReport', {'id': id});
            },
            function(error) {
                notificationService.setNotification('error', error.data);
            });
        }
    };

    helper.copyReport = function(reportId, newName, callerScope, overwrite, action)
    {
        if (reportId === undefined ||  reportId === null  || newName === '')
        {
            var error = notificationService.createObjectForNotification('error', 500, 'Query id or label is empty');
            notificationService.setNotification(error.type, error.data);
            return;
        }

        if (callerScope.savedSearchCategory === undefined ||  callerScope.savedSearchCategory.input === null  || callerScope.savedSearchCategory.input === '')
        {
            var error = notificationService.createObjectForNotification('error', 500, 'Category is not set');
            notificationService.setNotification(error.type, error.data);
            return;
        }

        var paramsToSend = {};
            paramsToSend.reportId    = reportId;
            paramsToSend.reportLabel = newName;
            paramsToSend.reportCategory = callerScope.savedSearchCategory.input;
            paramsToSend.overwrite   = overwrite;
            paramsToSend.is_public   = ( (callerScope.is_public !== undefined && callerScope.is_public.input === true) ? true: false)
            paramsToSend.sharedPermission = angular.toJson(callerScope.reportRoles);

        var data = $.param(paramsToSend);

        reportService.copyReport(data).then(
         function(result) {
             notificationService.setNotification('success', result.data);

             $rootScope.$broadcast('saveReport_saveSuccess_Event');
             callerScope.showOverwrite = false;

             if (action === 'result' && result.data[0].reportId !== '')
             {
                 wizardSharedService.resetScope();
                 $location.path('/report/run/'  + encodeURIComponent(result.data[0].reportId));
             }

         },
         function(error) {
            notificationService.setNotification('error', error.data);
            if(error.data[0]['errorCode'] === 422) {
              callerScope.showOverwrite = true;
            }
         });
    };


    /*
     *This functions is create VIEW related variables for allreports and listreports.
     *Provide support for sort by username and label
     */
    helper._setVIEWVariables = function(callerScope) {

        var header =  ['username', 'label', 'reportCategory'];
        callerScope.VIEW = {}
        callerScope.VIEW.sortColumn     = 'label';
        callerScope.VIEW.sortDescending = 0;
        callerScope.VIEW.tablehead ={};
        angular.forEach(header, function(field, key){
            var tmp   = {};
            tmp.name  = field;
            tmp.title = field;
            tmp.sort = 0;
            tmp.fieldIndex = key;
            tmp.nameToSort = tmp.name + '_' + key;
            callerScope.VIEW.tablehead[tmp.nameToSort] = tmp;
        });
    };

    /*
     * return true if user has admin role
     **/
    helper.checkifAdmin = function (roles) {
            var result = false;
            if (!helper._isObjEmpty(roles))
            {
                 angular.forEach(roles, function(role, key){
                    if (role === 'admin' && result !== true)
                    {
                        result = true;
                    }
                 });
            }
        return result;
    };

    /**
    *  Truncate string by length
    *
    * {{some_text | cut:true:100:' ...'
    *   wordwise (boolean) - if true, cut only by words bounds,
    *   max (integer) - max length of the text, cut to this number of chars,
    *   tail (string, default: ' …') - add this string to the input string if the string was cut.
    */
    helper.truncateString = function (value, wordwise, max, tail) {

            if (!value) return '';

            max = parseInt(max, 10);
            if (!max) return value;
            if (value.length <= max) return value;

            value = value.substr(0, max);
            if (wordwise) {
                var lastspace = value.lastIndexOf(' ');
                if (lastspace !== -1) {
                    value = value.substr(0, lastspace);
                }
            }

            return value + (tail || ' …');
        };


    /**
     * Set host context to the scope.
     * @param {type} scopeToSet - scope where we should set variables
     * @param {type} source scope with hostcontext
     * @returns {undefined}
     */

    helper.setContextVariables = function(scopeToSet, scopeObj) {
        var self = this;
        scopeToSet.hostcontexts          = scopeObj.hostcontexts;
        scopeToSet.hostcontextsprofileid = scopeObj.hostcontextsprofileid;
        scopeToSet.hostcontextspath      = scopeObj.hostcontextspath;
        scopeToSet.excludedHosts         = scopeObj.excludedHosts;

        scopeToSet.hostselectionstate = {
                                            'profileId'        : scopeObj.hostcontextsprofileid,
                                            'hostContextsPath' : scopeObj.hostcontextspath
                                         };
    }

    helper.removeHostkeyFromResult = function (queryResult) {
        // remove hostkey from header and result
        var k = 0, pos = -1;

        for (k = 0; k < queryResult.header.length; k++) {
            if (queryResult.header[k].columnName.toLowerCase() === 'hostkey') {
                pos = k;
                break;
            }
        }

        //remove hostkey from header and data
        if (pos !== -1) {
            queryResult.header.splice(pos, 1);
            angular.forEach(queryResult.rows, function (row, key) {
                row.splice(pos, 1);
            });
        }

        return queryResult;
    };

    helper.returnDate = function (days, startOfDay) {

        let todayDate = new Date();
        let date = new Date(new Date().setDate(todayDate.getDate() - days));

        if (startOfDay === true) {
            date.setHours(0, 0, 0, 0);
        }

        return date;
    };

    helper.sortObjectByKey = function (obj) {
        return Object.keys(obj).sort().reduce(function (result, key) {
            result[key] = obj[key];
            return result;
        }, {});
    };
    
    return helper;
}]);
