#!/usr/bin/env bash
# PHPUnit Unit Tests Runner
# This script runs the unit tests for mission-portal

# Source common setup
SCRIPT_DIR=$(dirname "$0")
source "${SCRIPT_DIR}/common-setup.sh"

# Run unit tests with coverage
result=running
sudo --preserve-env=GITLAB_BUILD_REPOSITORY_TOKEN -u cfapache  ./vendor/phpunit/phpunit/phpunit --coverage-clover="${NTECH_ROOT}/artifacts/coverage.xml" --log-junit "${NTECH_ROOT}/artifacts/phpunit-report.xml" --debug --verbose || result=fail

if [ "$result" = "fail" ]; then
  failure
  exit 1
fi
