# Role based access control

## How to add new RBAC rule

Write an annotation for a method:
```
/**
 * @rbacName Permission name
 * @rbacDescription additional information
 * @rbacGroup Permission group
 * @rbacAlias permission.alias
 * @rbacAllowedByDefault
 */
```
`@rbacAllowedByDefault` means that permission will be allowed by default for every role.

Then run rbac generator script as root on your hub:
```/var/cfengine/httpd/php/bin/php /var/cfengine/httpd/htdocs/index.php rbac_generator```

This script will generate sql with new, updated or deleted permissions.
Copy output SQL to [ootb_settings.sql](https://github.com/cfengine/nova/blob/master/db/ootb_settings.sql) and execute these SQL statements on your development hub (```/var/cfengine/bin/psql cfsettings```).

## Check action inside code

### PHP
If you need to check an action inside a function then you need to add following code:

```php
if (isActionAllowed('action.alias')) {
   //to do something
}
```
### JS

```js
if (await rbac.isActionAllowed('action.alias')){
    //to do something
}
```
* note that rbac.isActionAllowed returns a promise.

