<?php

if (!function_exists('camelCaseToUnderScore')) {
    function camelCaseToUnderScore(string $str): string
    {
        return strtolower(preg_replace("/[A-Z]/", "_$0", $str));
    }

    function underScoreToCamelCase(string $str): string
    {
        return  lcfirst(str_replace(' ', '', ucwords(str_replace('_', ' ', $str))));
    }
}

if (!function_exists('generateRandomString')) {
    function generateRandomString(int $length): string
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $randomString = '';

        for ($i = 0; $i < $length; $i++) {
            $index = rand(0, strlen($characters) - 1);
            $randomString .= $characters[$index];
        }

        return $randomString;
    }
}

if (!function_exists('boolToYesNo')) {
    function boolToYesNo(bool $bool): string
    {
        return $bool ? 'yes' : 'no';
    }
}

if (!function_exists('valueOrNA')) {
    function valueOrNA($value): string
    {
        return $value ?? 'n/a';
    }
}
