<?php

class FileChangedConditionSetter extends BaseComplianceSetter
{
    public function setCondition(array &$condition, array $data = [])
    {
        $rule = $condition['rules'];
        if (!isset($rule['condition'])) {
            throw new Exception("File changes condition `{$condition['name']}` is missing rule's condition");
        }
        $condition['fileChangedConditions'] = [
            'fileName' => $rule['file-name'],
            'condition' => $rule['condition'],
            'timePeriod' => $rule['time-period']
        ];
    }
}
