define({ "api": [
  {
    "type": "post",
    "url": "inventory",
    "title": "Reports",
    "name": "Inventory",
    "group": "Inventory",
    "version": "1.0.0",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Authorization",
            "description": "<p>User token. Exmp.: <code>Bearer f9c6000853a90e4043b745263786777e0ff0011e</code></p>"
          },
          {
            "group": "Header",
            "type": "String",
            "allowedValues": [
              "application/json"
            ],
            "optional": false,
            "field": "Content-Type",
            "description": ""
          }
        ]
      }
    },
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "array",
            "optional": false,
            "field": "select",
            "description": "<p>Fields for selecting Emp.: <code>[&quot;Host name&quot;, &quot;OS type&quot;, &quot;IPv4 addresses&quot;, &quot;CFEngine version&quot;,&quot;Ports listening&quot;]</code></p>"
          },
          {
            "group": "Parameter",
            "type": "json",
            "optional": true,
            "field": "filter",
            "description": "<p>Filter data Emp.: <code>{&quot;:field_name&quot; : {&quot;:operator&quot; : &quot;:field_value&quot;, &quot;:operator&quot; : &quot;:field_value&quot;}, &quot;:field_name&quot; : {&quot;:operator&quot; : &quot;:field_value&quot;}</code></p>"
          },
          {
            "group": "Parameter",
            "type": "json",
            "optional": false,
            "field": "sort",
            "description": "<p>Field name for sorting with &quot;-&quot; for DESC order. Emp: <code>{&quot;sort&quot; : &quot;-Host name&quot;}</code></p>"
          },
          {
            "group": "Parameter",
            "type": "integer",
            "optional": true,
            "field": "start",
            "description": "<p>Number of results to skip for the processed query. Optional parameter.</p>"
          },
          {
            "group": "Parameter",
            "type": "integer",
            "optional": true,
            "field": "limit",
            "description": "<p>Limit the number of results in the query. Default value is 1000, max value is 10000.</p>"
          },
          {
            "group": "Parameter",
            "type": "array",
            "optional": true,
            "field": "hostContextInclude",
            "description": "<p>Includes value for filtering.</p>"
          },
          {
            "group": "Parameter",
            "type": "array",
            "optional": true,
            "field": "hostContextExclude",
            "description": "<p>Excludes value for filtering.</p>"
          }
        ],
        "Filter parameters": [
          {
            "group": "Filter parameters",
            "type": "string",
            "optional": true,
            "field": "field_name",
            "description": "<p>Name of field for filtering</p>"
          },
          {
            "group": "Filter parameters",
            "type": "string",
            "allowedValues": [
              "lt",
              "gt",
              "eq",
              "neq",
              "lteq",
              "gteq",
              "l",
              "nl",
              "il",
              "nil"
            ],
            "optional": true,
            "field": "operator",
            "description": "<p>Operator for filtering.</p>"
          },
          {
            "group": "Filter parameters",
            "type": "string",
            "optional": true,
            "field": "field_value",
            "description": "<p>Value of field for filtering.</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n \"data\": [\n   {\n     \"header\": [\n       {\n         \"columnName\": \"hostkey\",\n         \"columnType\": \"STRING\"\n       },\n       {\n         \"columnName\": \"values\",\n         \"columnType\": \"STRING\"\n       }\n     ],\n     \"queryTimeMs\": 293,\n     \"rowCount\": 1,\n     \"rows\": [\n       [\n         \"SHA=0713d888be810b110bf710b569b0a3594dcf586a0418db4b677ea17ccbe1488c\",\n         \"{\\\"default.sys.interfaces\\\" : \\\" {\\\"enp0s3\\\",\\\"enp0s8\\\"}\\\", \\\"default.sys.fqhost\\\" : \\\"localhost\\\", \\\"default.sys.hardware_addresses\\\" : \\\"   {\\\"08:00:27:b0:12:47\\\",\\\"08:00:27:c5:9a:83\\\"}\\\", \\\"default.sys.cpus\\\" : \\\"2\\\", \\\"default.sys.class\\\" : \\\"linux\\\", \\\"default.sys.release\\\" : \\\"4.8.0-36-generic\\\", \\\"default.sys.key_digest\\\" : \\\"SHA=0713d888be810b110bf710b569b0a3594dcf586a0418db4b677ea17ccbe1488c\\\", \\\"default.sys.cf_version\\\" : \\\"3.11.0a.5c98a70\\\", \\\"default.sys.arch\\\" : \\\"x86_64\\\", \\\"default.cfe_autorun_inventory_ipv4_addresses.ipv4[192.168.56.103]\\\" : \\\"192.168.56.103\\\", \\\"default.cfe_autorun_inventory_ipv4_addresses.ipv4[10.0.2.15]\\\" : \\\"10.0.2.15\\\", \\\"default.cfe_autorun_inventory_cpuinfo.cpu_model\\\" : \\\"Intel(R) Core(TM) i3-4160 CPU @ 3.60GHz\\\", \\\"default.cfe_autorun_inventory_dmidecode.dmi[bios-version]\\\" : \\\"VirtualBox\\\", \\\"default.cfe_autorun_inventory_dmidecode.dmi[system-manufacturer]\\\" : \\\"innotek GmbH\\\", \\\"default.cfe_autorun_inventory_dmidecode.dmi[system-serial-number]\\\" : \\\"0\\\", \\\"default.cfe_autorun_inventory_dmidecode.dmi[system-product-name]\\\" : \\\"VirtualBox\\\", \\\"default.cfe_autorun_inventory_dmidecode.dmi[bios-vendor]\\\" : \\\"innotek GmbH\\\", \\\"default.inventory_os.description\\\" : \\\"Ubuntu 16.04\\\", \\\"default.cfe_autorun_inventory_dmidecode.dmi[system-version]\\\" : \\\"1.2\\\", \\\"default.cfe_autorun_inventory_proc_cpuinfo.cpuinfo_physical_socket_inventory\\\" : \\\"1\\\", \\\"default.cfe_autorun_inventory_cpuinfo.cpuinfo_physical_cores\\\" : \\\"2\\\", \\\"default.cfe_autorun_inventory_memory.total\\\" : \\\"6393.29\\\", \\\"default.sys.uptime\\\" : \\\"4057\\\", \\\"default.cfe_autorun_inventory_listening_ports.ports\\\" : \\\" {\\\"22\\\",\\\"53\\\",\\\"80\\\",\\\"443\\\",\\\"5308\\\",\\\"5432\\\"}\\\", \\\"default.cfe_autorun_inventory_disk.free\\\" : \\\"84.00\\\", \\\"policy_server\\\" : \\\"policy_server\\\"}\"\n       ]\n     ]\n   }\n ],\n \"meta\": {\n   \"count\": 1,\n   \"page\": 1,\n   \"timestamp\": 1495020761,\n   \"total\": 1\n }\n}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Wrong operator:",
          "content": "HTTP/1.1 500 Internal Server Error\n  Wrong abbreviation of operator",
          "type": "string"
        }
      ]
    },
    "filename": "../controllers/Inventory.php",
    "groupTitle": "Inventory",
    "sampleRequest": [
      {
        "url": "https://localhost/api/inventory"
      }
    ]
  },
  {
    "type": "patch",
    "url": "variables-dictionary/:id",
    "title": "Edit variable",
    "name": "VariablesDictionaryEdit",
    "group": "Variables_Dictionary",
    "version": "1.0.0",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Authorization",
            "description": "<p>User token. Exmp.: <code>Bearer f9c6000853a90e4043b745263786777e0ff0011e</code></p>"
          },
          {
            "group": "Header",
            "type": "String",
            "allowedValues": [
              "application/json"
            ],
            "optional": false,
            "field": "Content-Type",
            "description": ""
          }
        ]
      }
    },
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "int",
            "optional": false,
            "field": "id",
            "description": "<p>Variable Id</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "category",
            "description": "<p>Category</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "allowedValues": [
              "int",
              "real",
              "slist",
              "string"
            ],
            "optional": false,
            "field": "type",
            "description": "<p>Variable type</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "convert_function",
            "description": "<p>Convert Function</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n\n{\n  \"id\": 1,\n  \"attribute_name\": \"Architecture\",\n  \"category\": \"Hardware\",\n  \"readonly\": 0,\n  \"type\": \"slist\",\n  \"convert_function\": \"cf_clearSlist\"\n}",
          "type": "json"
        }
      ]
    },
    "error": {
      "examples": [
        {
          "title": "Validation errors:",
          "content": "HTTP/1.1 400 Bad Request\n[\n\"Type is wrong. Allowed values: int,real,slist,string\",\n\"Convert function is wrong. Allowed values: cf_clearSlist\"\n]",
          "type": "string"
        },
        {
          "title": "Forbidden error:",
          "content": "HTTP/1.1 403 Forbidden\nYou cannot edit read only variable",
          "type": "string"
        }
      ]
    },
    "filename": "../controllers/VariablesDictionary.php",
    "groupTitle": "Variables_Dictionary",
    "sampleRequest": [
      {
        "url": "https://localhost/api/variables-dictionary/:id"
      }
    ]
  },
  {
    "type": "get",
    "url": "variables-dictionary",
    "title": "List of variables",
    "name": "VariablesDictionaryList",
    "group": "Variables_Dictionary",
    "version": "1.0.0",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Authorization",
            "description": "<p>User token. Exmp.: <code>Bearer f9c6000853a90e4043b745263786777e0ff0011e</code></p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n[\n  {\n    \"id\": 2,\n    \"attribute_name\": \"BIOS vendor\",\n    \"category\": \"Hardware\",\n    \"readonly\": 1,\n    \"type\": \"string\",\n    \"convert_function\": null\n  },\n  {\n    \"id\": 3,\n    \"attribute_name\": \"BIOS version\",\n    \"category\": \"Hardware\",\n    \"readonly\": 1,\n    \"type\": \"string\",\n    \"convert_function\": null\n  }\n]",
          "type": "json"
        }
      ]
    },
    "filename": "../controllers/VariablesDictionary.php",
    "groupTitle": "Variables_Dictionary",
    "sampleRequest": [
      {
        "url": "https://localhost/api/variables-dictionary"
      }
    ]
  },
  {
    "type": "post",
    "url": "variables-dictionary",
    "title": "Add custom variables to data dictionary",
    "name": "VariablesDictionaryUpdate",
    "group": "Variables_Dictionary",
    "version": "1.0.0",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Authorization",
            "description": "<p>User token. Exmp.: <code>Bearer f9c6000853a90e4043b745263786777e0ff0011e</code></p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK",
          "type": "json"
        }
      ]
    },
    "filename": "../controllers/VariablesDictionary.php",
    "groupTitle": "Variables_Dictionary",
    "sampleRequest": [
      {
        "url": "https://localhost/api/variables-dictionary"
      }
    ]
  }
] });
