<?php

//******************************* M O D A L *******************************************************
$this->load->view('/partials/_saveSearchModal');
$this->load->view('/partials/_copySearchModal');
$this->load->view('/partials/_diffModal');
//******************************* M O D A L *******************************************************
?>
    <div class="pageTitle">
        <h1>
            <span>File integrity monitoring</span>
        </h1>
    </div>
    <div>
        <div id="filterTree" ng-init="showFilter=false" ng-class="{'open':showFilter}">
            <div class="accordion-group">
                <div class="accordion-toggle accordion-heading" data-parent="#filterTree" data-toggle="collapse">
            <span ng-click="showFilter=!showFilter" id="filterToggle">
                <i class="icon-chevron-right" ng-show="!showFilter" style="padding: 0px 5px;"></i>
                <i class="icon-chevron-down" ng-show="showFilter" style="padding: 0px 5px;"></i>
                Filters <span ng-show="originalFilters.length" class="help-block inline"
                              style="font-size:14px; font-style:normal">({{originalFilters.length}})</span>
            </span>
                </div>
            </div>

            <div ng-show="showFilter" class="margin-left-small margin-bottom-small">
                <?php $this->load->view('/partials/_environmentFilter'); ?>
            </div>

        </div>
        <div>

        <label class="pull-right">
            <input
                    date-range-picker
                    class="form-control date-picker pull-right"
                    type="text"
                    ng-model="filterDateRange"
                    options="dateOpts"
                    max="todayDate"
            >
            <span class="micro-copy help-block">Filter by date</span>
        </label>

    </div>
    </div>
    <div style="margin-top: 120px">
        <div class="controls hostFilter filesDropdown" style="float: left; margin-right: 20px">
            <select
                    required
                    data-placeholder="Search"
                    chosen-files-auto-complete
                    ng-model="searchCompleteSelected"
                    watch="searchComplete"
                    ng-options="item.name group by item.type for item in searchComplete track by item.id"
                    ng-change="selectHost(searchCompleteSelected)"
            ></select>
        </div>
        <div class="pull-right">
            <span>Show change type: </span>

            <span class="margin-left">
                <label class="checkbox inline">
                    <input type="checkbox" ng-model="typeFilter.contentChange"> Content change
                </label>
                <label class="checkbox inline">
                    <input type="checkbox" ng-model="typeFilter.diff">DIFF
                </label>
                <label class="checkbox inline">
                    <input type="checkbox" ng-model="typeFilter.fileAdded">File added
                </label>
                <label class="checkbox inline">
                    <input type="checkbox" ng-model="typeFilter.fileRemoved">File removed
                </label>
                <label class="checkbox inline">
                    <input type="checkbox" ng-model="typeFilter.fileStats">File stats
                </label>
        </span>
        </div>

    </div>

    <div class="fim_data" style="margin-top: 180px;">
        <input type="hidden" value="{{SQL.SQLSTRING}}" id="angularSQLString">
        <input type="hidden" value="{{VIEW.sortColumn}}" id="angularSQLSortColumn">
        <input type="hidden" value="{{VIEW.sortDescending}}" id="angularSQLSortDescending">
        <input type="hidden" value="{{SQL.hostcontexts.includes | json}}" id="angularhostsContextInclude">
        <input type="hidden" value="{{SQL.excludedHosts.excludes | json}}" id="angularhostsContextExclude">
        <?php $this->load->view('/partials/_notification'); ?>
        <div class="sql-result-block margin-top row-fluid" ng-show="VIEW.rowCount">
            <?php $this->load->view('/partials/_pagination'); ?>
            <div class="horizontal-scroll sql-result-table-wrapper margin-bottom">
                <table id="inventory-table" class="table table-bordered float-left margin-top" style="margin-bottom:0">
                    <thead>
                    <tr>
                        <th id="header{{$index}}" class="sort-head" ng-repeat="head in VIEW.tablehead"
                            ng-click="sortReorder(head.nameToSort, $event)">
                            <div style="width:100%; margin-right:32px;position:relative">
                                <span>{{head.name}}</span>
                                <i ng-class="{'icon-chevron-up':head.sort<0,'icon-chevron-down':head.sort>0}"></i>
                                <i class="placeholder-icon icon-reorder"></i>
                            </div>
                        </th>
                    </tr>
                    </thead>
                    <tbody tr-rows rowdata="VIEW.rows" tablehead="VIEW.tablehead" replaceNull="true">
                    </tbody>
                </table>
            </div>
            <?php $this->load->view('/partials/_pagination'); ?>
        </div>
        <div id="resultScrollTo" class="margin-top">
            <?php
            $data['buttonPosition'] = "bottom";
            $data['showEdit'] = false;
            $this->load->view('/partials/elements/_resultPageBtn', $data);
            ?>
        </div>
        <div class="pull-right go-to-top"><i class="icon-arrow-up"></i></div>
        <div class="pull-right go-to-bottom"><i class="icon-arrow-down"></i></div>
    </div>
