<?php

class CF_Widget {
    var $id;
    var $username;
    var $name;
    var $type;
    var $payload;
    var $alerts; // combinations of rules, hosts, notifications | array
    var $ordering; // combinations of rules, hosts, notifications | array


    //var $runtime; // do not use now


    function __construct($params=array()) {
        $this->id         = isset($params['id'])         ? $params['id']        : null;
        $this->username   = isset($params['username'])   ? $params['username']  : null;
        $this->name       = isset($params['name'])       ? $params['name']      : null;
        $this->type       = isset($params['type'])       ? $params['type']      : null;
        $this->ordering   = !empty($params['ordering'])  ? $params['ordering']  : null;
        $this->payload   = !empty($params['payload'])  ? $params['payload']  : null;

        $this->alerts     = !empty($params['alerts'])    ? explode(',',$params['alerts']) : array();

    }

    function getId() {
        return $this->id;
    }

    function getUsername() {
        return $this->username;
    }

    function getName() {
        return $this->name;
    }

    function getPayload() {
        return $this->payload;
    }

    function getType() {
        return $this->type;
    }

    function getAlerts() {
        return $this->alerts;
    }

    function getOrdering() {
        return $this->ordering;
    }

}
?>