<?php

class SettingsRolesImporter extends BaseDataImporter
{
    public function isOnlyForAdmin(): bool
    {
        return true;
    }

    public function import($data)
    {
        $data = json_decode($data, JSON_OBJECT_AS_ARRAY);
        foreach ($data as $role) {
            $this->settingsDb->reset_query();
            $filter = ['name' => $role['name']];
            $roleExist = $this->settingsDb->get_where('roles', $filter);

            $role['is_default'] = boolval($role['is_default']) == true ? 't' : 'f';
            if ($roleExist->num_rows() == 0) {
                $this->settingsDb->insert('roles', $role);
            } elseif ($this->skipDuplicates == 0) {
                $this->settingsDb->update('roles', $role, $filter);
            }
        }
    }
}
