<?php
include_once FCPATH . 'application/controllers/Csv2pdf.php';

class pdfreports extends Cf_Controller
{

    public $storeDir;
    public $storeDirCsv;

    // pattern for validating filenames to prevent command injection
    const SAFE_FILENAME_PATTERN = '/^[a-zA-Z0-9_-]+$/';

    // allowed file extensions for report downloads
    const ALLOWED_FILE_EXTENSIONS = ['csv', 'pdf'];

    function __construct()
    {
        parent::__construct();
        $this->load->model(array('report_model', 'pdfreports_model'));
        $this->load->helper('string');
        $this->load->library('cfe_file_reports_utils');   // include additional functions to report.

        $this->storeDir = $this->storeDirCsv = get_tmpdir();

        $this->predefinedKeys = array(
            'hostkey',
            'type',
            'search',
            'class_regex',
            'days',
            'months',
            'years',
            'address',
            'ago',
            'version',
            'arch',
            'cal',
            'to',
            'from',
            'subject',
            'message',
            'diff',
            'scope',
            'lval',
            'rval',
            'state',
            'key',
            'rf',
            'inclist',
            'exlist',
            'date',
            'cause',
            'var_type',
            'clevel',
            'host_only',
            'patch-type',
            'log-type'
        );
    }

    /**
     * general clean up for parameter
     */
    function cleanParams($params)
    {

        if (empty($params['from']) && !is_int($params['from']))
            $params['from'] = 0;
        if (empty($params['to']) && !is_int($params['to']))
            $params['to'] = time();
        return $params;
    }

    function index()
    {
        $params = $this->uri->uri_to_assoc(3, $this->predefinedKeys);
        $report_type = isset($params['type']) ? urldecode($params['type']) : $this->input->post('type');
        $report_category = trim($this->input->post('report_category'));
        $params = $this->cleanParams($params);

        $report_format = 'pdf';
        if (isset($params['rf']) && (trim($params['rf']) != ''))
        {
            $report_format = trim($params['rf']);
        }

        //order expression already presents into inventory query
        $isInventory = strstr($this->input->post('sqlString'),'inventory_new');
        if($this->input->post('sqlSortColumn') && !$isInventory){
            $params['sqlSortColumn'] = $this->input->post('sqlSortColumn');
            $params['sqlSortDescending'] = $this->input->post('sqlSortDescending');
        }

        $params = array_map('urldecode', $params);

        if ($this->input->post('rf') != null)
        {
            $report_format = $this->input->post('rf');
        }

        $report_download = isset($params['download']) && trim($params['download'] != '') ? $params['download'] : $this->input->post('download');


        // it all download so pagination paramteres are null
        $params['page'] = null;
        $params['rows'] = null;

        if ($report_type == 'advancedreports')
        {
            if ($this->input->post('sqlString') != null && $report_category != 'changes')
            {
                $params['query'] = trim($this->input->post('sqlString'));
            }
            else
            {
                $data['text'] = $this->lang->line('advancedreports_SQL_string_is_empty');
                $data['errorCode'] = 500;
                respond_internal_error(json_encode($data));
            }

            if ($this->input->post('report_title') != null)
            {
                $params['report_title'] = trim(urldecode($this->input->post('report_title')));
            }
            else
            {
                $data['text'] = $this->lang->line('advancedreports_title_is_empty');
                $data['errorCode'] = 500;
                respond_internal_error(json_encode($data));
            }

            if ($this->input->post('report_description') != null)
            {
                $params['report_description'] = trim(urldecode($this->input->post('report_description')));
            }


            if ($this->input->post('includes') != null)
            {
                $params['includes'] = $this->input->post('includes');
            }

	        if ($this->input->post('excludes') != null)
	        {
		        $params['excludes'] = $this->input->post('excludes');
	        }

        }

        $timezone = isset($params['timezone']) && trim($params['timezone'] != '') ? $params['timezone'] : $this->input->post('timezone');

        $this->cfe_file_reports_utils->setReportTimeZone($timezone);

        $filename = 'CFEngine_Enterprise_' . preg_replace('/ /', '_', $report_type) . "-" . date('m-d-Y-His') . '_' . random_string('alnum', 32);
        $filename_with_extension = $filename . '.csv';


        $this->cfe_file_reports_utils->setStoreDir($this->storeDir);

        $this->cfe_file_reports_utils->setFilename($filename . '.' . $report_format);

        $this->cfe_file_reports_utils->setReportGenerator($report_format, $report_type, NULL);
        $this->cfe_file_reports_utils->setRestClient($this->getRestClient());


         /* Check report category - if 'changes' or 'compliance', then use report_csvArray param to build csv file */
        if (($report_category == 'changes' || $report_category == 'compliance') && $report_format !== 'json')
        {
            $status = [];
            /* Format JSON into correct format for  */
            $csvArray = trim($this->input->post('report_csvArray'));
            $csvArray = json_decode($csvArray, true);

            /* get url for filename to write to */
            $url = $this->storeDir;

            $fp = fopen($url. $filename_with_extension, 'w');

            foreach ($csvArray as $fields)
            {

                foreach ($fields as $key=>$field_entry)
                {
                    if (gettype($field_entry) == 'array')
                    {
                        // convert to string if array, such as log messages
                        $comma_separated = implode('","', $field_entry);
                        $fields[$key] = '{"' . $comma_separated . '"}';
                    }

                }
                fputcsv($fp, $fields);
            }

            fclose($fp);
            $this->cfe_file_reports_utils->attachFiles($this->cfe_file_reports_utils->getfilename());
            //change $filename_with_extension to the right one, previous version has always .csv
            //for internal stuff, like converting csv to pdf
            $filename_with_extension = $filename . '.' . $report_format;
        } elseif ($report_format === 'json' && $report_category === 'compliance') {
            $complianceData = json_decode($this->input->post('compliance_data'), true);
            $this->load->model('advancedreports/compliance_exchange');
            $this->compliance_exchange->setUsername($this->session->userdata('username'));
            $filename_with_extension = $this->compliance_exchange->export(intval($complianceData['reportId']));
            $filename = pathinfo($filename_with_extension)['filename'];
            $this->cfe_file_reports_utils->attachFiles($filename);
            $status = 100;
        }
        else
        {
            try
            {
                $status = $this->cfe_file_reports_utils->generateReports($this->session->userdata('username'), $report_type, $params);
                $filename = $status['id'];
                $filename_with_extension = $status['id'] . '.' . $report_format; // in status[id] we have filename. like md5=123456tduaegf
                $this->cfe_file_reports_utils->attachFiles($this->cfe_file_reports_utils->getfilename());
            }
            catch (Exception $e)
            {
                $data['text'] = $e->getMessage();
                $data['errorCode'] = 500;
                respond_internal_error(json_encode($data));
            }
        }


        $downloadLink = site_url() . "/pdfreports/download/file/$filename_with_extension/action/downloadLocal";

        if ($report_type != 'advancedreports')
        {
            $retData = array('op' => 'checkStatus',
                'filename' => $filename_with_extension,
                'statuscheck' => $filename_with_extension . '.status',
                'downloadlink' => $downloadLink,
                'reportformat' => $report_format,
                'basefilename' => $filename,
                'reportId' => $report_type,
                'status' => $status);
        }
        else
        {
            $retData = array('op' => 'checkStatus',
                'filename' =>  $filename_with_extension, // in status[id] we have filename. like md5=123456tduaegf;
                //'statuscheck'  => '',
                //'downloadlink' => $downloadLink,
                'reportformat' => $report_format,
                'basefilename' => $filename,
                'reportId' => $report_type,
                'status' => $status,
                'reportTitle' => $params['report_title'],
                'reportDescription' => $params['report_description'] ?? '',
                'reportCategory' => $report_category
            );
        }

        if ($report_category == 'compliance') {
            $retData['compliance_data'] = $this->input->post('compliance_data');
        }

        $jsonReturn = json_encode($retData);
        respond_ok($jsonReturn);
    }

    /**
     * Function to download the given file and cleanup
     */
    function download()
    {
        $this->load->helper('download');
        $params = $this->uri->uri_to_assoc(3);
        $filename = isset($params['file']) ? urldecode($params['file']) : null;
        $this->downloadFile($this->storeDir, $filename);
    }

    public function downloadFile($path, $filename)
    {
        if (is_null($filename) || empty($filename))
        {
            show_404();
        }

        $downloadFile = realpath($path . $filename);
        $allowedDir = realpath($this->storeDir);

        if (!$downloadFile || !$allowedDir)
        {
            show_404();
        }

        // normalize paths with trailing separator for accurate comparison
        $allowedDir = rtrim($allowedDir, DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR;

        // security check: ensure the file is within the allowed directory
        if (strpos($downloadFile . DIRECTORY_SEPARATOR, $allowedDir) !== 0)
        {
            show_404();
        }

        if (!is_file($downloadFile))
        {
            show_404();
        }

        push_file($downloadFile, $filename);
        @unlink($downloadFile);
    }

    /**
     * @param $filename
     * @deprecated Will be removed
     */
    function downLoadFromApi($filename)
    {
        $url  = $this->config->item('rest_server');
        $remotePath = $url.'/static/'.$filename;
        log_message('debug',"Requesting file from API server ".$remotePath);
        push_file_remote($remotePath,$filename);
    }

    function sendEmail()
    {
        $this->load->model('pdfreports_model');

        try
        {
            log_message('info', "pdfreports->sendEmail(): Start");
            $to = $this->input->post('to');
            $from = $this->input->post('from');
            $subject = $this->input->post('subject');
            $msg = $this->input->post('message');
            $filename = $this->input->post('filename');

            $reportId = $this->input->post('reportId');
            $downloadLink = $this->input->post('downloadLink');


            // Note: for the advanced reports we receive download link from API as parameter
            if ($reportId != 'advancedreports')
            {
                $downloadLink = site_url() . "/pdfreports/download/file/$filename/action/downloadLocal";
            }
            $attachment = $this->pdfreports_model->checkFileSize($filename);
            log_message('info', "pdfreports->sendEmail(): downloadLink: $downloadLink");

            if (empty($to) || empty($from) || empty($filename) || empty($downloadLink))
            {
                $errorMsg = $this->lang->line('send_email_error');
                $data = array('message' => "Some data for sending emails are missing.");
                respond_internal_error(json_encode($data), $errorMsg);
            }


            $this->email->from($from);
            $this->email->to($to);
            $this->email->subject($subject);

            $emailContent = $msg;
            $this->load->model('MailSettingsModel');

            if(is_array($attachment) and $attachment['fileSize'] < $this->MailSettingsModel->getSetting('max_email_attach_size')){
                $this->email->attach($attachment['filePath']);
            }else{
                $dataToReplace = [
                    'attachmentSize' => round($attachment['fileSize']),
                    'currentlySettingsSize' =>  $this->MailSettingsModel->getSetting('max_email_attach_size'),
                    'settingsUrl' => site_url() . '/settings/mail'
                ];

                $timeZone   = 'gmt';
                $emailContent  .= "\n";
                $emailContent  .= 'Your report is generated at '.getDateStatus(time(), true, true, $timeZone);
                $emailContent  .=  vsprintf(' was too large (%s MB) to attach to the email. You can adjust the maximum email attachment size (currently %s MB) in Settings: %s or use the link provided below to download the report.', $dataToReplace);

                $emailContent .= "\n" . '------ Please use the link below to download the file -----' . "\n";
                $emailContent .= $downloadLink;
            }


            $this->email->message($emailContent);

            log_message('info', "pdfreports->sendEmail(): to: $to, from: $from, subject: $subject, emailContent: $emailContent");

            if (!$this->email->send())
            {
                $errorMsg = $this->lang->line('send_email_error');
                $data = array('message' => $errorMsg);
                log_message('error', "pdfreports->sendEmail(): Unable to send. Error: $errorMsg");
                respond_internal_error(json_encode($data), $errorMsg);
                return;
            }

            $retData = array('message' => $this->lang->line('send_email_success'));
            log_message('info', "pdfreports->sendEmail(): Success");
            respond_ok(json_encode($retData));
        }
        catch (Exception $e)
        {
            $data = array('message' => $e->getMessage());
            log_message(log_level_for_exception($e), "pdfreports->sendEmail(): Unable to send. Error: ".$e->getMessage());
            respond_internal_error(json_encode($data), 'Email send error');
        }
    }


    function _checkFileStatus($basePath, $type, $filename)
    {

        $path = get_tmpdir() . $basePath . '.' . $type . '.status';
        $pidFile = get_tmpdir() . $basePath . '.' . $type . '.pid';

        $status = @file_get_contents($path);
        $pid = @file_get_contents($pidFile);

        $extData['href'] = site_url() . "/pdfreports/download/file/$filename/action/downloadLocal";


        $this->_analyzeAndRespondStatus($status, $pid, $type, $filename, $extData, null);
    }

    /*
     * Use for change reports to check if they exist
     */
    function _checkFileExists($basePath, $type, $filename)
    {
        $path = get_tmpdir() . $basePath . '.' . $type;
        $pid = '';
        $status = false;
        if (file_exists($path)) {
            $status = 100;
            //copy($path, $newfile)
        }

        $extData['href'] = site_url() . "/pdfreports/download/file/$filename/action/downloadLocal";

        $this->_analyzeAndRespondStatus($status, $pid, $type, $filename, $extData, 'changes');
    }

    function _analyzeAndRespondStatus($status, $pid, $type, $filename, $extData = array(), $category)
    {
        $returnData = new stdClass();

        if ($status === false)
        {
            $returnData->status = 0;
            $returnData->message = 'something went wrong while preparing reports (cannot get status).';
            $returnData->state = 'fail';
            $returnData->extData = $extData; // extra data in case we have to provide more info

            log_message('error', "pdfreports->_analyzeAndRespondStatus(): Error: ".$returnData->message);

            $data = json_encode($returnData);
            respond_internal_error($data);
        }
        elseif ($status == 100)
        {
            $returnData->status = 100;
            $returnData->message = $type . ' generation finished';
            $returnData->state = 'complete';
            if ($type == 'pdf' || $category == 'changes')
            {
                $extData['href'] = site_url() . "/pdfreports/download/file/$filename/action/downloadLocal";
            }
            else if ($type == 'csv')
            {
                log_message('debug', "Downloading from API");
                //$filename = basename($extData['href']);
                $extData['href'] = site_url() . "/pdfreports/download/file/$filename/action/downloadLocal/path/".base64_encode($this->storeDirCsv);
            }

            $returnData->downloadLink = $extData['href']; // extra data in case we have to provide more info

            $data = json_encode($returnData);
            respond_ok($data);
        }
        else
        {
            if ($type == 'pdf')
            {
                // If the status equals to $statusBeforeHtmlWriting it means that writing html process takes some time
                // and we need to inform users about this case.
                // When PDF files are small, users won't notice this message
                $msg  = $status === Csv2Pdf::$statusBeforeHtmlWriting ?
                    'Generating the PDF file <i class="icon-spinner icon-spin"></i> <br /> This process may take a few minutes.' :
                    'Preparing data...';
            }
            else
            {
                $msg = 'Preparing data...';
            }

            // if in the halfway and process is not there , error


            if ($type == "pdf" && (!$pid || !$this->_isRunning($pid)))
            {
                $returnData->status = -1;
                $returnData->message = "Process aborted";
                $returnData->state = 'fail';

                $data = json_encode($returnData);
                respond_internal_error($data);
                return;
            }

            $returnData->status = $status;
            $returnData->message = $msg;
            $returnData->state = 'busy';

            $data = json_encode($returnData);
            respond_ok($data);
        }
    }

    function _checkAdvancedReportFileStatus($jobId, $type, $filename)
    {
        $this->advancedreports_model->setRestClient($this->getRestClient());
        $data = $this->advancedreports_model->getReportJobStatus($this->session->userdata('username'), $jobId);

        $status = 0;
        if (!empty($data['error']))
        {
            $status = false;
        }
        else if (!empty($data['percentageComplete']))
        {
            $status = $data['percentageComplete'];
        }
        $this->_analyzeAndRespondStatus($status, null, $type, $filename, $data, null);
    }

    function checkDownloadStatus()
    {
        $reportId = $this->input->post('reportId');
        $extensionToCheck = $this->input->post('checkFile'); // This is file type

        $reportCategory = $this->input->post('reportCategory');

        $filename = $this->input->post('filename');

        if ($extensionToCheck == 'pdf' || strtolower($reportId) != 'advancedreports')
        {
            $basefilename = $this->input->post('basefilename'); //'test2.pdf';
            $this->_checkFileStatus($basefilename, $extensionToCheck, $basefilename.'.'.$extensionToCheck);
        }
        elseif ($extensionToCheck == 'json') {
            $basefilename = $this->input->post('basefilename');
            $this->_checkFileExists($basefilename, $extensionToCheck, $filename);
        }
        else if (
            strtolower($reportId) == 'advancedreports' &&
            ($reportCategory == 'changes' || $reportCategory == 'compliance')
        )
        {
            $basefilename = $this->input->post('basefilename');
            $this->_checkFileExists($basefilename, $extensionToCheck, $filename);
        }
        else
        {
            $jobId = $this->input->post('jobId');
            $this->_checkAdvancedReportFileStatus($jobId, $extensionToCheck, $filename);
        }
    }

    function _isRunning($pid)
    {
        try
        {
            // cast to int for additional safety
            $result = shell_exec(sprintf("ps %d", (int) $pid));
            if (count(preg_split("/\n/", $result)) > 2)
            {
                return true;
            }
        }
        catch (Exception $e)
        {

        }

        return false;
    }

    public function fireOffPdfGeneration()
    {
        $reportID = $this->input->post('reportId');
        $reportCategory = $this->input->post('reportCategory');
        $reportTitle = $this->input->post('reportTitle');
        $reportDescription = $this->input->post('reportDescription');
        $fileext = $this->input->post('checkFile');
        $basefilename = $this->input->post('basefilename');
        $jobId = $this->input->post('jobId');

        // validate reportID - allow alphanumeric and common report names
        if (!preg_match(self::SAFE_FILENAME_PATTERN, $reportID)) {
            respond_internal_error('Invalid report ID format: contains disallowed characters');
            return;
        }

        // validate filename - allow only alphanumeric, dash, underscore
        if (!preg_match(self::SAFE_FILENAME_PATTERN, $basefilename)) {
            respond_internal_error('Invalid filename format: contains disallowed characters');
            return;
        }

        // validate file extension - whitelist only allowed extensions
        if (!in_array($fileext, self::ALLOWED_FILE_EXTENSIONS, true)) {
            respond_internal_error('Invalid file extension: ' . $fileext);
            return;
        }

        if ($reportCategory == 'compliance') {
            $this->load->model('PdfComplianceReports_model');
            $this->PdfComplianceReports_model->generateReport(
                [
                $basefilename,
                $this->input->post('compliance_data'),
                $reportTitle,
                $reportDescription
                ]
            );
        }

        if ($reportID != 'advancedreports' || ($reportCategory == 'changes'))
        {
            $fileName = $basefilename;
            $baseCsvFile = realpath(get_tmpdir()) . DIRECTORY_SEPARATOR . $fileName . '.' . $fileext;
        }
        else
        {
            if (!preg_match(self::SAFE_FILENAME_PATTERN, $jobId)) {
                respond_internal_error('Invalid job ID format: contains disallowed characters');
                return;
            }
            $fileName = $jobId;
            $baseCsvFile = $this->storeDirCsv . $fileName . '.csv';
        }

        $this->pdfreports_model->convertCSVtoPDF($fileName, $baseCsvFile, $reportID, $reportTitle, $reportDescription, $fileName);
    }

    public function cancelReportGeneration()
    {
        $reportId = $this->input->post('reportId');
        $extensionToCheck = $this->input->post('checkFile'); // This is file type
        $basefilename = $this->input->post('basefilename');
        $jobId = $this->input->post('jobId');

        // validate reportId
        if (!preg_match(self::SAFE_FILENAME_PATTERN, $reportId)) {
            respond_internal_error('Invalid report ID format: contains disallowed characters');
            return;
        }

        // validate file extension - whitelist
        if (!in_array($extensionToCheck, self::ALLOWED_FILE_EXTENSIONS, true)) {
            respond_internal_error('Invalid file extension: ' . $extensionToCheck);
            return;
        }

        if ($extensionToCheck == 'pdf' || strtolower($reportId) != 'advancedreports')
        {
            // validate basefilename when used in this code path
            if (!preg_match(self::SAFE_FILENAME_PATTERN, $basefilename)) {
                respond_internal_error('Invalid filename format: contains disallowed characters');
                return;
            }

            // construct and validate file path to ensure it's within allowed directory
            $tmpDir = realpath(get_tmpdir());
            $baseFile = $tmpDir . DIRECTORY_SEPARATOR . $basefilename . '.abort';
            $resolvedPath = realpath(dirname($baseFile));

            // ensure the resolved path is within tmp directory
            if (!$resolvedPath || !$tmpDir) {
                respond_internal_error('Invalid file path');
                return;
            }

            // normalize paths with trailing separator for accurate comparison
            $allowedDir = rtrim($tmpDir, DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR;
            $checkPath = rtrim($resolvedPath, DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR;

            if (strpos($checkPath, $allowedDir) !== 0) {
                respond_internal_error('File path outside allowed directory');
                return;
            }

            file_put_contents($baseFile, ''); // just write blank file
            respond_ok($baseFile);
        }
        else
        {
            // validate jobId when used in this code path
            if (!preg_match(self::SAFE_FILENAME_PATTERN, $jobId)) {
                respond_internal_error('Invalid job ID format: contains disallowed characters');
                return;
            }

            $data = $this->advancedreports_model->cancelReportJob($this->session->userdata('username'), $jobId);
            respond_ok($data); // will return true on success
        }
    }

}