<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * To retrive specific things from app settings and user settings
 */
class Setting_lib
{

    protected $errors = array();
    protected $username;

    public function __construct()
    {
        $this->ci = & get_instance();

        $this->ci->load->model('settings_model');
        $this->ci->load->model('settings_rest_model');
        $this->ci->load->library('ion_auth');
        $this->username = $this->ci->session->userdata('username');
        $this->settings_model = $this->ci->settings_model;

        $this->settings_rest_model=$this->ci->settings_rest_model;
        $this->settings_rest_model->setRestClient(Cf_RestInstance::getRestClient());//$this->ci->getRestClient());
    }

    public function get_blue_host_threshold()
    {
        return $this->settings_rest_model->app_settings_get_item('bluehost_threshold_global');
    }


    /**
     * Returns the state of rbac
     * (In DB it is set as true or false in string)
     * @return boolean  if it is set returns (bool)true else false
     */
    public function get_rbac_setting()
    {
        return $this->settings_rest_model->app_settings_get_item('rbacEnabled');
    }

    /**
     *  return current authentication mode.
     * @return type Example results: database, ldap, active_directory
     */
    public function get_authentication_mode()
    {
        return $this->settings_rest_model->app_settings_get_item('ldapMode');
    }

    public function if_ldap_enabled()
    {
        return $this->settings_rest_model->app_settings_get_item('ldapEnabled');
    }

    public function getSecuritySettings() : array
    {
        return array_intersect_key(
            $this->settings_rest_model->get_app_settings(),
            array_flip([
                Settings_rest_model::MIN_PASSWORD_LENGTH,
                Settings_rest_model::PASSWORD_COMPLEXITY,
                Settings_rest_model::PASSWORD_EXPIRATION_AFTER_RESET_HOURS
            ])
        );
    }

}

