<?php

class SettingsPreferencesImporter extends BaseDataImporter
{
    public function isOnlyForAdmin(): bool
    {
        return true;
    }

    public function import($data)
    {
        if(isset($this->phar['pdf_logo.jpg'])) {
            file_put_contents(FCPATH . 'tmp/pdf_logo.jpg', $this->phar['pdf_logo.jpg']->getContent());
        }
        $data = json_decode($data, JSON_OBJECT_AS_ARRAY);
        foreach ($data as $setting) {
            $this->db->reset_query();
            $exist = $this->settingsDb->get_where('settings', ['key' => $setting['key']]);

            if ($exist->num_rows() == 0) {
                $this->settingsDb->insert('settings', $setting);
            } elseif ($this->skipDuplicates == 0) {
                $this->settingsDb->set('value', $setting['value']);
                $this->settingsDb->where('key', $setting['key']);
                $this->settingsDb->update('settings');
            }

        }

    }
}
