'use strict';

var buildApp = angular.module('buildApp', [
        'ngSanitize',
        'ngRoute',
        'notifications',
        'ui.bootstrap',
        'ngCookies',
        'projectsServiceModule',
        'masterfilesVersionServiceModule',
        'modulesServiceModule',
        'sshKeyServiceModule',
        'cmdbServiceServiceModule',
        'hubManagementServiceModule',
        'actionServiceModule',
        'moduleDataDirective',
    ],
    function ($routeProvider, $locationProvider) {
        $locationProvider.hashPrefix('');

        $routeProvider.when('/', {
            template: "",
            controller: projectsMainController
        });

        $routeProvider.when('/project/create', {
            templateUrl: MP_SITE_URL + '/build_app/build/partials/projects/create',
            controller: projectsController
        });

        $routeProvider.when('/project/edit/:id', {
            templateUrl: MP_SITE_URL + '/build_app/build/partials/projects/create',
            controller: projectsController
        });

        $routeProvider.when('/project/:id', {
            templateUrl: MP_SITE_URL + '/build_app/build/partials/projects/view',
            controller: projectsViewController
        });

        $routeProvider.when('/modules', {
            templateUrl: MP_SITE_URL + '/build_app/build/partials/modules/list',
            controller: modulesListController
        });

        $routeProvider.when('/external/modules/:name', {
            templateUrl: MP_SITE_URL + '/build_app/build/partials/modules/module',
            controller: externalModulesPageController
        });

        $routeProvider.when('/modules/:name', {
            templateUrl: MP_SITE_URL + '/build_app/build/partials/modules/module',
            controller: modulesPageController
        });

        $locationProvider.html5Mode(true);
    }
);
