<?php

class Assets extends CF_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('host_model');
        $this->load->model('report_model');
        $this->load->model('note_model');
        $this->load->model('assets_model');
        $this->load->model('advancedreports_model');

        $this->load->library(array('cfe_table'));

        $this->username = $this->session->userdata('username');
        setCurrentApplication('engineering');

    }

    function node_assets()
    {
        $this->load->view('assets/assets-main-node', array());
    }

    function host_assets($hostkey='')
    {
        $this->load->helper('elements_creator');
        $requiredjs = array(
            array('node_modules/jquery.flot/jquery.flot.js'),
            array('node_modules/jquery.flot/jquery.flot.stack.js'),
            array('node_modules/jquery.flot/jquery.flot.resize.js'),
            array('node_modules/jquery.flot/jquery.flot.fillbetween.js'),
            array('widgets/notes.js'),
            array('node_modules/jquery-appear-original/index.js'),
            array('widgets/vitalsigns.js'),
            array('node_modules/clipboard/dist/clipboard.min.js'),
            array('host-page.js')
        );

        $jsIE = array('node_modules/jquery.flot/excanvas.min.js');
        $this->carabiner->group('iefix', array('js' => $jsIE));
        $this->carabiner->js($requiredjs);

        $requiredAngularjs = array(
            array('node_modules/underscore/underscore-min.js'),
            array('node_modules/angular/angular.min.js'),
            array('node_modules/angular-cookies/angular-cookies.min.js'),
            array('node_modules/angular-route/angular-route.min.js'),
            array('node_modules/angular-sanitize/angular-sanitize.min.js'),

            // services
            array('libs/angularjs-ui/ui-bootstrap-tpls-0.9.0.min.js'),
            array('libs/class.js'),

            array('libs/baseclasses/BaseController.js'),
            array('libs/baseclasses/EventDispatcher.js'),
            array('libs/baseclasses/Notifications.js'),

            array('hostInfo/app.js'),
            array('hostInfo/controllers/hostInfoController.js'),
            array('hostInfo/services/cmdbService.js'),
            array('hostInfo/directives/cmdb.js'),
            array('hostInfo/data/cmdbSuggestions.js'),
            array('hubManagement/services/hubManagementService.js'),
            array('common_directives/objectsFilter.js'),
        );

        $this->carabiner->js($requiredAngularjs, $requiredAngularjs, $combine = true, $minify = false);

        $username = $this->username;
        $assetsData = array();
        $data = array();
        if (!empty($hostkey))
        {
            try {
                $hostInfo = $this->host_model->getHostInfo($username,$hostkey, true);
            } catch (Exception $e) {
                $this->show_404();
                return;
            }
            $policiesExecutionInfo = $this->host_model->getPolicyExecutionData($username, $hostkey);
            $hostname = !empty($hostInfo['hostname']) ? $hostInfo['hostname'] : null;
            $ipaddr =  !empty($hostInfo['ip']) ? $hostInfo['ip'] : null;
            $lastUpdate = !empty($hostInfo['lastreport']) ? $hostInfo['lastreport'] : null;
            $firstReport = !empty($hostInfo['firstreport']) ? $hostInfo['firstreport'] : null;

            $this->load->model(['eventslog_model', 'hub_management/setup_hub_model']);
            $bootstrappedEvent = $this->eventslog_model->get_all_events("message LIKE '%" . $this->db->escape_like_str($hostkey). " was bootstrapped%'");
            $cfengineRoles = $this->host_model->getHostVariableDataByName($hostkey, "CFEngine roles");
            
            $data = array(
                'title' => $this->lang->line('mission_portal_title'),
                'showHeader' => !is_ajax() ? true : false ,
                'hostkey' => $hostkey,
                'title' => $this->lang->line('mission_portal_title') . " - host " . $ipaddr,
                'hostname' => $hostname,
                'ipaddr' => $ipaddr,
                'last' => $lastUpdate,
                'firstReport' => $firstReport,
                'load' =>  $this->host_model->getHostVariable($username, $hostkey, "cfe_autorun_inventory_loadaverage", "value"),
                'free' =>  $this->host_model->getHostVariableDataByName($hostkey, "Disk free (%)") ,
                // set firstreporttimestamp as bootstrappedAt in case of missing bootstrap event, what happens on superhubs
                'bootstrappedAt' =>  isset($bootstrappedEvent[0]->time) ? $bootstrappedEvent[0]->time : $firstReport,
                'collectionInitiatedBy' => $hostInfo['iscallcollected'] == true ? 'Client' : 'Hub',
                'lastAgentExecutionTime' =>  $hostInfo['lastAgentExecutionTime'],
                'agentExecutionInterval' =>  $hostInfo['agentexecutioninterval'],
                'policiesExecutionInfo' => $policiesExecutionInfo,
                // find if `CFEngine roles` contains `Reporting hub` or `policy_server` (value reported by hubs before 3.24.0)
                'isHub' =>  sizeof(array_filter(['Reporting hub', 'policy_server'], fn ($value) => str_contains($cfengineRoles, $value))) > 0,
                'isSuperHub' => $this->setup_hub_model->isSuperHub()
            );


            if (isActionAllowed('host-groups-shared.get')) {
                try {
                    $data['groups'] = $this->host_model->getSharedGroupsByHostkey($hostkey);
                } catch( Exception $e) {
                    error_log("Unexpected error calling getSharedGroupsByHostkey(" . $hostkey . "). Exception: " . $e);
                    return;
                }
            } else {
                $data['groups_access_denied'] = true;
            }

            $software_installed = $this->report_model->getSoftwareInstalled($this->username,$hostkey, null, null, null, array(), array(), $rows = 1, $page_number = 1, $hosts_only = false);
            $pathches_available = $this->report_model->getPatches($this->username,$hostkey, null, null, null, 'AVAILABLE', array(), array(), $rows = 1, $page_number = 1, $hosts_only = false);
            $pathches_installed = $this->report_model->getPatches($this->username,$hostkey, null, null, null, 'INSTALLED', array(), array(), $rows = 1, $page_number = 1, $hosts_only = false);


            $data['software_installed'] = $software_installed['rowCount'];
            $data['patches_installed'] = $pathches_installed['rowCount'];
            $data['patches_available'] = $pathches_available['rowCount'];


            $data['software_installed_query'] = $software_installed['query'];
            $data['patches_installed_query'] = $pathches_installed['query'];
            $data['patches_available_query'] = $pathches_available['query'];

            $data['software_installed_state'] = base64_encode(json_encode($this->assets_model->getSoftwareInstalledParams($hostkey)));
            $data['patches_available_state'] = base64_encode(json_encode($this->assets_model->getAvailableSoftwareParams($hostkey)));

            $assetsData = array_merge($assetsData, $data, $hostInfo);

            if (is_ajax())
            {
                $this->load->view('assets/assets-main-host', $assetsData);
            }
            else
            {
                $this->template->load('templates/singleColumnTemplate', 'assets/assets-main-host', $assetsData);
            }
        }
        else
        {
            if (is_ajax())
            {
                $this->load->view('assets/error', array());
            }
            else
            {
                $this->template->load('template', 'assets/error', array());
            }
        }
    }


    function host_assets_by_name($hostName = '')
    {
        $username = $this->username;

        if (!empty($hostName))
        {
            // get hostkey and redirect to host_assets
            $SQLString = sprintf("SELECT hostkey FROM hosts WHERE hostName='%s'", urldecode($hostName));

            $data = $this->advancedreports_model->runQuery($username, $SQLString);


            if (count($data['rows']) === 1)
            {
                redirect('hosts/'.$data['rows'][0][0]); //$data['rows'][0][0] contain hostkey
            }



            // show user page where he can see what happened.
            // scenarious can be:
            // 1. not able to find host with the given name
            // 2. more than 1 host with the same name.

            $assetsData = array();
            $assetsData['hostName'] = urldecode($hostName);


            if (empty($data['rows']))
            {
               $this->template->load('templates/singleColumnTemplate', 'assets/assets-host-not-found', $assetsData);
            }
            elseif (count($data['rows'])>1)
            {
               $SQLString = sprintf('SELECT Hosts.HostKey AS "Host key", Hosts.HostName AS "Host name", Hosts.IPAddress AS "IP address"  FROM Hosts WHERE hostname = \'%s\'', urldecode($hostName));

               $data = $this->advancedreports_model->runQuery($username, $SQLString);
               $assetsData['hostData'] = $data['rows'];

               $this->template->load('templates/singleColumnTemplate', 'assets/assets-many-host-with-same-name', $assetsData);
            }
        }
        else
        {
            $this->template->load('templates/singleColumnTemplate', 'assets/assets-host-name-empty', $assetsData);
        }
    }

}
