<?php
if (PHP_SAPI == 'cli-server') {
    // To help the built-in PHP dev server, check if the request was actually for
    // something which should probably be served as a static file
    $url  = parse_url($_SERVER['REQUEST_URI']);
    $file = __DIR__ . $url['path'];
    if (is_file($file)) {
        return false;
    }
}

define('BASEPATH', __DIR__ . '/');
define('CONFIG_PATH', __DIR__ . '/config');

require __DIR__ . '/vendor/autoload.php';

session_start();

// Instantiate the app
$settings = require CONFIG_PATH . '/settings.php';
$app = new \Slim\App($settings);



//Set up autoload
require_once __DIR__ . '/autoload.php';

// Set up dependencies
require __DIR__ . '/src/dependencies.php';

// Register middleware
require __DIR__ . '/src/middleware.php';

// Register routes
require __DIR__ . '/src/routes.php';

// Run app
$app->run();
