angular.module('breadcrumbsDirective', [])
    .directive('breadcrumbs', [function () {
        return {
            restrict: 'A',
            scope: {
                data: '='
            },
            template: `<ol class="breadcrumb margin-top">
                          <li ng-repeat="item in items"><a href="{{ item.url }}">{{ item.name }}</a></li>
                          <li class="active">{{ lastItem }}</li>
                       </ol>`,

            link: function ($scope) {
                $scope.items = [];
                $scope.lastItem = '';
                $scope.$watch('data', () => {
                    Object.keys($scope.data).forEach(item => {
                        // last item has no url
                        if ($scope.data[item] !== '') {
                            $scope.items.push({name: item, url: $scope.data[item]});
                        } else {
                            $scope.lastItem = item;
                        }
                    })
                });
            }
        };
    }]);
