<?php

require_once APPPATH . 'libraries/Cf_REST_Controller.php';

class TourGuide extends Cf_REST_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model( 'TourGuide_model' );
    }

    function seenTour_get() {
        $username = $this->session->userdata( 'username' );
        $seenTour = $this->TourGuide_model->getSeenTourByUserName( $username );
        $this->respond( 200, json_encode( $seenTour ) );
    }

    function seenTour_post() {
        $username = $this->session->userdata( 'username' );
        $postData = json_decode( $this->request->body, true );
        $this->TourGuide_model->changeSeenTourByUserName( $username, $postData['seenTour'] );
        $this->respond( 201, '' );
    }

}