<?php


class SharedGroupCmdb_model extends Cf_Model
{
    private $endpoint = '/host-groups/shared/%d/cmdb';

    private function getUrl($groupId): string
    {
        return sprintf($this->endpoint, $groupId);
    }

    public function getItem($groupId)
    {
        return json_decode($this->getRestClient()->get($this->getUrl($groupId)), $associative = true);
    }

    public function updateItem($groupId, $type, $name, $value)
    {
        $this->getRestClient()->patch("{$this->getUrl($groupId)}/$type/$name/", $value);
    }

    public function createItem($groupId, $type, $name, $value)
    {
        $this->getRestClient()->post("{$this->getUrl($groupId)}/$type/$name/", $value);
    }

    public function deleteItem($groupId, $type, $name)
    {
        return $this->getRestClient()->delete("{$this->getUrl($groupId)}/$type/$name/");
    }

    public function getItemByName($groupId, $type, $name)
    {
        return $this->getRestClient()->get("{$this->getUrl($groupId)}/$type/$name/");
    }
}
